/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.util.concurrent.SettableFuture;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.RedisCommandBuilder;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.AsyncCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.concurrent.Future;

class PlainChannelInitializer
extends ChannelInitializer<Channel>
implements RedisChannelInitializer {
    static final RedisCommandBuilder<String, String> INITIALIZING_CMD_BUILDER = new RedisCommandBuilder<String, String>(new Utf8StringCodec());
    protected boolean pingBeforeActivate;
    private List<ChannelHandler> handlers;
    protected SettableFuture<Boolean> initializedFuture = SettableFuture.create();

    public PlainChannelInitializer(boolean pingBeforeActivateConnection, List<ChannelHandler> handlers) {
        this.pingBeforeActivate = pingBeforeActivateConnection;
        this.handlers = handlers;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (channel.pipeline().get("channelActivator") == null) {
            channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                private AsyncCommand<?, ?, ?> pingCommand;

                @Override
                public Future<Boolean> channelInitialized() {
                    return PlainChannelInitializer.this.initializedFuture;
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.initializedFuture = SettableFuture.create();
                    this.pingCommand = null;
                    super.channelInactive(ctx);
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                        ctx.channel().close();
                    }
                    if (evt instanceof ConnectionEvents.Activated && !PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.set((Object)true);
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (PlainChannelInitializer.this.pingBeforeActivate) {
                        this.pingCommand = new AsyncCommand<String, String, String>(INITIALIZING_CMD_BUILDER.ping());
                        PlainChannelInitializer.pingBeforeActivate(this.pingCommand, PlainChannelInitializer.this.initializedFuture, ctx, PlainChannelInitializer.this.handlers);
                    } else {
                        super.channelActive(ctx);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.setException(cause);
                    }
                    super.exceptionCaught(ctx, cause);
                }
            });
        }
        for (ChannelHandler handler : this.handlers) {
            PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
            channel.pipeline().addLast(new ChannelHandler[]{handler});
        }
    }

    static void pingBeforeActivate(AsyncCommand<?, ?, ?> cmd, SettableFuture<Boolean> initializedFuture, ChannelHandlerContext ctx, List<ChannelHandler> handlers) throws Exception {
        cmd.handle((o, throwable) -> {
            if (throwable == null) {
                initializedFuture.set((Object)true);
                ctx.fireChannelActive();
            } else {
                initializedFuture.setException(throwable);
            }
            return null;
        });
        ctx.channel().writeAndFlush(cmd);
    }

    static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerClass) {
        ChannelHandler channelHandler = pipeline.get(handlerClass);
        if (channelHandler != null) {
            pipeline.remove(channelHandler);
        }
    }

    @Override
    public Future<Boolean> channelInitialized() {
        return this.initializedFuture;
    }
}

