/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.ConnectionPoint;
import com.lambdaworks.redis.EpollProvider;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionStateListener;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractRedisClient {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClient.class);
    protected static final PooledByteBufAllocator BUF_ALLOCATOR = PooledByteBufAllocator.DEFAULT;
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(Runtime.getRuntime().availableProcessors() * 4)));
    protected EventExecutorGroup genericWorkerPool;
    protected final Map<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroups;
    protected final HashedWheelTimer timer;
    protected final ChannelGroup channels;
    protected long timeout = 60L;
    protected TimeUnit unit;
    protected ConnectionEvents connectionEvents = new ConnectionEvents();
    protected Set<Closeable> closeableResources = Sets.newConcurrentHashSet();
    protected ClientOptions clientOptions = new ClientOptions.Builder().build();

    protected AbstractRedisClient() {
        this.timer = new HashedWheelTimer();
        this.eventLoopGroups = new ConcurrentHashMap<Class<? extends EventLoopGroup>, EventLoopGroup>();
        this.genericWorkerPool = new DefaultEventExecutorGroup(DEFAULT_EVENT_LOOP_THREADS);
        this.channels = new DefaultChannelGroup(this.genericWorkerPool.next());
        this.timer.start();
        this.unit = TimeUnit.SECONDS;
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T connectAsyncImpl(CommandHandler<K, V> handler, T connection, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(this.clientOptions);
        this.connectionBuilder(handler, connection, socketAddressSupplier, connectionBuilder, null);
        this.channelType(connectionBuilder, null);
        return this.initializeChannel(connectionBuilder);
    }

    protected void connectionBuilder(CommandHandler<?, ?> handler, RedisChannelHandler<?, ?> connection, Supplier<SocketAddress> socketAddressSupplier, ConnectionBuilder connectionBuilder, RedisURI redisURI) {
        Bootstrap redisBootstrap = new Bootstrap();
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)32768);
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)8192);
        redisBootstrap.option(ChannelOption.ALLOCATOR, (Object)BUF_ALLOCATOR);
        if (redisURI == null) {
            redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.unit.toMillis(this.timeout)));
            connectionBuilder.timeout(this.timeout, this.unit);
        } else {
            redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)redisURI.getUnit().toMillis(redisURI.getTimeout())));
            connectionBuilder.timeout(redisURI.getTimeout(), redisURI.getUnit());
        }
        connectionBuilder.bootstrap(redisBootstrap);
        connectionBuilder.channelGroup(this.channels).connectionEvents(this.connectionEvents).timer((Timer)this.timer);
        connectionBuilder.commandHandler(handler).socketAddressSupplier(socketAddressSupplier).connection(connection);
        connectionBuilder.workerPool(this.genericWorkerPool);
    }

    protected void channelType(ConnectionBuilder connectionBuilder, ConnectionPoint connectionPoint) {
        connectionBuilder.bootstrap().group(this.getEventLoopGroup(connectionPoint));
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            connectionBuilder.bootstrap().channel(EpollProvider.epollDomainSocketChannelClass);
        } else {
            connectionBuilder.bootstrap().channel(NioSocketChannel.class);
        }
    }

    private synchronized EventLoopGroup getEventLoopGroup(ConnectionPoint connectionPoint) {
        if (!(connectionPoint != null && connectionPoint.getSocket() != null || this.eventLoopGroups.containsKey(NioEventLoopGroup.class))) {
            this.eventLoopGroups.put(NioEventLoopGroup.class, (EventLoopGroup)new NioEventLoopGroup(DEFAULT_EVENT_LOOP_THREADS));
        }
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            if (!this.eventLoopGroups.containsKey(EpollProvider.epollEventLoopGroupClass)) {
                EventLoopGroup epl = EpollProvider.newEventLoopGroup(DEFAULT_EVENT_LOOP_THREADS);
                this.eventLoopGroups.put(EpollProvider.epollEventLoopGroupClass, epl);
            }
        }
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            return this.eventLoopGroups.get(EpollProvider.epollEventLoopGroupClass);
        }
        return this.eventLoopGroups.get(NioEventLoopGroup.class);
    }

    private void checkForEpollLibrary() {
        EpollProvider.checkForEpollLibrary();
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T initializeChannel(ConnectionBuilder connectionBuilder) {
        RedisChannelHandler<?, ?> connection = connectionBuilder.connection();
        SocketAddress redisAddress = connectionBuilder.socketAddress();
        try {
            logger.debug("Connecting to Redis, address: " + redisAddress);
            Bootstrap redisBootstrap = connectionBuilder.bootstrap();
            RedisChannelInitializer initializer = connectionBuilder.build();
            redisBootstrap.handler((ChannelHandler)initializer);
            ChannelFuture connectFuture = redisBootstrap.connect(redisAddress);
            connectFuture.await();
            if (!connectFuture.isSuccess()) {
                if (connectFuture.cause() instanceof Exception) {
                    throw (Exception)connectFuture.cause();
                }
                connectFuture.get();
            }
            try {
                initializer.channelInitialized().get(connectionBuilder.getTimeout(), connectionBuilder.getTimeUnit());
            }
            catch (TimeoutException e) {
                throw new RedisConnectionException("Could not initialize channel within " + connectionBuilder.getTimeout() + " " + (Object)((Object)connectionBuilder.getTimeUnit()), e);
            }
            connection.registerCloseables(this.closeableResources, connection, connectionBuilder.commandHandler());
            return (T)connection;
        }
        catch (RedisException e) {
            connection.close();
            throw e;
        }
        catch (Exception e) {
            connection.close();
            throw new RedisConnectionException("Unable to connect to " + redisAddress, e);
        }
    }

    public void shutdown() {
        this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        this.timer.stop();
        while (!this.closeableResources.isEmpty()) {
            Closeable closeableResource = this.closeableResources.iterator().next();
            try {
                closeableResource.close();
            }
            catch (Exception e) {
                logger.debug("Exception on Close: " + e.getMessage(), (Throwable)e);
            }
            this.closeableResources.remove(closeableResource);
        }
        for (Channel c : this.channels) {
            PubSubCommandHandler psCommandHandler;
            ChannelPipeline pipeline = c.pipeline();
            CommandHandler commandHandler = (CommandHandler)pipeline.get(CommandHandler.class);
            if (commandHandler != null && !commandHandler.isClosed()) {
                commandHandler.close();
            }
            if ((psCommandHandler = (PubSubCommandHandler)pipeline.get(PubSubCommandHandler.class)) == null || psCommandHandler.isClosed()) continue;
            psCommandHandler.close();
        }
        ArrayList closeFutures = Lists.newArrayList();
        ChannelGroupFuture closeFuture = this.channels.close();
        closeFutures.add(this.genericWorkerPool.shutdownGracefully(quietPeriod, timeout, timeUnit));
        closeFutures.add(closeFuture);
        for (EventLoopGroup eventExecutors : this.eventLoopGroups.values()) {
            Future groupCloseFuture = eventExecutors.shutdownGracefully(quietPeriod, timeout, timeUnit);
            closeFutures.add(groupCloseFuture);
        }
        for (Future future : closeFutures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RedisException(e);
            }
        }
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    public void addListener(RedisConnectionStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    protected void setOptions(ClientOptions clientOptions) {
        Preconditions.checkArgument((clientOptions != null ? 1 : 0) != 0, (Object)"clientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

