/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.PlainChannelInitializer;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.protocol.CommandEncoder;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConnectionBuilder {
    private Supplier<SocketAddress> socketAddressSupplier;
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;
    private CommandHandler<?, ?> commandHandler;
    private ChannelGroup channelGroup;
    private Timer timer;
    private Bootstrap bootstrap;
    private ClientOptions clientOptions;
    private EventExecutorGroup workerPool;
    private long timeout;
    private TimeUnit timeUnit;

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public ConnectionBuilder socketAddressSupplier(Supplier<SocketAddress> socketAddressSupplier) {
        this.socketAddressSupplier = socketAddressSupplier;
        return this;
    }

    public SocketAddress socketAddress() {
        Preconditions.checkState((this.socketAddressSupplier != null ? 1 : 0) != 0, (Object)"socketAddressSupplier must be set");
        return (SocketAddress)this.socketAddressSupplier.get();
    }

    public ConnectionBuilder timeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ConnectionBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConnectionBuilder workerPool(EventExecutorGroup workerPool) {
        this.workerPool = workerPool;
        return this;
    }

    public ConnectionBuilder connectionEvents(ConnectionEvents connectionEvents) {
        this.connectionEvents = connectionEvents;
        return this;
    }

    public ConnectionBuilder connection(RedisChannelHandler<?, ?> connection) {
        this.connection = connection;
        return this;
    }

    public ConnectionBuilder channelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public ConnectionBuilder commandHandler(CommandHandler<?, ?> commandHandler) {
        this.commandHandler = commandHandler;
        return this;
    }

    public ConnectionBuilder timer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ConnectionBuilder bootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    protected List<ChannelHandler> buildHandlers() {
        Preconditions.checkState((this.channelGroup != null ? 1 : 0) != 0, (Object)"channelGroup must be set");
        Preconditions.checkState((this.connectionEvents != null ? 1 : 0) != 0, (Object)"connectionEvents must be set");
        Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (Object)"connection must be set");
        ArrayList handlers = Lists.newArrayList();
        if (this.clientOptions.isAutoReconnect()) {
            Preconditions.checkState((this.bootstrap != null ? 1 : 0) != 0, (Object)"bootstrap must be set for autoReconnect=true");
            Preconditions.checkState((this.timer != null ? 1 : 0) != 0, (Object)"timer must be set for autoReconnect=true");
            Preconditions.checkState((this.socketAddressSupplier != null ? 1 : 0) != 0, (Object)"socketAddressSupplier must be set for autoReconnect=true");
            ConnectionWatchdog watchdog = new ConnectionWatchdog(this.clientOptions, this.bootstrap, this.timer, this.workerPool, this.socketAddressSupplier);
            watchdog.setListenOnChannelInactive(true);
            handlers.add(watchdog);
        }
        this.connection.setOptions(this.clientOptions);
        handlers.add(new ChannelGroupListener(this.channelGroup));
        handlers.add(new CommandEncoder());
        handlers.add(this.commandHandler);
        handlers.add(this.connection);
        handlers.add(new ConnectionEventTrigger(this.connectionEvents, this.connection));
        return handlers;
    }

    public RedisChannelInitializer build() {
        return new PlainChannelInitializer(this.clientOptions.isPingBeforeActivateConnection(), this.buildHandlers());
    }

    public RedisChannelHandler<?, ?> connection() {
        return this.connection;
    }

    public CommandHandler<?, ?> commandHandler() {
        return this.commandHandler;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    @ChannelHandler.Sharable
    private static class ChannelGroupListener
    extends ChannelInboundHandlerAdapter {
        private ChannelGroup channels;

        public ChannelGroupListener(ChannelGroup channels) {
            this.channels = channels;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channels.add((Object)ctx.channel());
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.channels.remove((Object)ctx.channel());
            super.channelInactive(ctx);
        }
    }
}

