/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.protocol.CommandWrapper;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.Collection;
import java.util.function.Supplier;
import rx.Observable;
import rx.Subscriber;

public class ReactiveCommandDispatcher<K, V, T>
implements Observable.OnSubscribe<T> {
    private Supplier<? extends RedisCommand<K, V, T>> commandSupplier;
    private RedisCommand<K, V, T> command;
    private StatefulConnection<K, V> connection;
    private boolean dissolve;

    public ReactiveCommandDispatcher(RedisCommand<K, V, T> staticCommand, StatefulConnection<K, V> connection, boolean dissolve) {
        this(() -> staticCommand, connection, dissolve);
    }

    public ReactiveCommandDispatcher(Supplier<RedisCommand<K, V, T>> commandSupplier, StatefulConnection<K, V> connection, boolean dissolve) {
        Preconditions.checkArgument((commandSupplier != null ? 1 : 0) != 0, (Object)"CommandSupplier must not be null");
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (Object)"StatefulConnection must not be null");
        this.commandSupplier = commandSupplier;
        this.connection = connection;
        this.dissolve = dissolve;
        this.command = commandSupplier.get();
    }

    public void call(Subscriber<? super T> subscriber) {
        RedisCommand<K, V, T> command = this.command;
        if (command == null) {
            command = this.commandSupplier.get();
        }
        this.connection.dispatch(new ObservableCommand<K, V, T>(command, subscriber, this.dissolve));
        this.command = null;
    }

    private static class ObservableCommand<K, V, T>
    extends CommandWrapper<K, V, T> {
        private final Subscriber<? super T> subscriber;
        private final boolean dissolve;
        private boolean completed = false;

        public ObservableCommand(RedisCommand<K, V, T> command, Subscriber<? super T> subscriber, boolean dissolve) {
            super(command);
            this.subscriber = subscriber;
            this.dissolve = dissolve;
        }

        @Override
        public void complete() {
            if (this.completed) {
                return;
            }
            super.complete();
            if (this.getOutput() != null) {
                Object result = this.getOutput().get();
                if (result != null) {
                    if (this.dissolve && result instanceof Collection) {
                        Collection collection = (Collection)result;
                        for (Object t : collection) {
                            this.subscriber.onNext(t);
                        }
                    } else {
                        this.subscriber.onNext(result);
                    }
                }
                if (this.getOutput().hasError()) {
                    this.subscriber.onError((Throwable)new RedisCommandExecutionException(this.getOutput().getError()));
                    this.completed = true;
                    return;
                }
            }
            this.completed = true;
            this.subscriber.onCompleted();
        }

        @Override
        public void cancel() {
            if (this.completed) {
                return;
            }
            super.cancel();
            this.subscriber.onCompleted();
            this.completed = true;
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            if (this.completed) {
                return false;
            }
            boolean b = super.completeExceptionally(throwable);
            this.subscriber.onError(throwable);
            this.completed = true;
            return b;
        }
    }
}

