/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterNodeCommandHandler;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PooledClusterConnectionProvider<K, V>
implements ClusterConnectionProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.class);
    private final LoadingCache<ConnectionKey, StatefulRedisConnection<K, V>> connections;
    private final boolean debugEnabled;
    private final StatefulRedisConnection<K, V>[] writers = new StatefulRedisConnection[16384];
    private final StatefulRedisConnection<K, V>[][] readers = new StatefulRedisConnection[16384][];
    private final RedisClusterClient redisClusterClient;
    private Partitions partitions;
    private boolean autoFlushCommands = true;
    private Object stateLock = new Object();
    private ReadFrom readFrom;

    public PooledClusterConnectionProvider(RedisClusterClient redisClusterClient, RedisChannelWriter<K, V> clusterWriter, RedisCodec<K, V> redisCodec) {
        this.redisClusterClient = redisClusterClient;
        this.debugEnabled = logger.isDebugEnabled();
        this.connections = CacheBuilder.newBuilder().build(new ConnectionFactory<K, V>(redisClusterClient, redisCodec, clusterWriter));
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, int slot) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + slot + ")");
        }
        if (intent == ClusterConnectionProvider.Intent.READ && this.readFrom != null) {
            return this.getReadConnection(slot);
        }
        return this.getWriteConnection(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisConnection<K, V> getWriteConnection(int slot) {
        StatefulRedisConnection<K, V> writer;
        Object object = this.stateLock;
        synchronized (object) {
            writer = this.writers[slot];
        }
        if (writer == null) {
            RedisClusterNode partition = this.partitions.getPartitionBySlot(slot);
            if (partition == null) {
                throw new RedisException("Cannot determine a partition for slot " + slot + " (Partitions: " + this.partitions + ")");
            }
            try {
                RedisURI uri = partition.getUri();
                ConnectionKey key = new ConnectionKey(ClusterConnectionProvider.Intent.WRITE, uri.getHost(), uri.getPort());
                this.writers[slot] = (StatefulRedisConnection)this.connections.get((Object)key);
                return this.writers[slot];
            }
            catch (UncheckedExecutionException e) {
                throw new RedisException(e.getCause());
            }
            catch (Exception e) {
                throw new RedisException(e);
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisConnection<K, V> getReadConnection(int slot) {
        StatefulRedisConnection<K, V>[] statefulRedisConnectionArray = this.stateLock;
        synchronized (this.stateLock) {
            StatefulRedisConnection<K, V>[] readerCandidates = this.readers[slot];
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (readerCandidates == null) {
                RedisClusterNode master = this.partitions.getPartitionBySlot(slot);
                if (master == null) {
                    throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ")");
                }
                final List<RedisNodeDescription> candidates = this.getReadCandidates(master);
                List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                    @Override
                    public List<RedisNodeDescription> getNodes() {
                        return candidates;
                    }

                    @Override
                    public Iterator<RedisNodeDescription> iterator() {
                        return candidates.iterator();
                    }
                });
                if (selection.isEmpty()) {
                    throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ") with setting " + this.readFrom);
                }
                readerCandidates = this.getReadFromConnections(selection);
                this.readers[slot] = readerCandidates;
            }
            for (StatefulRedisConnection<K, V> readerCandidate : readerCandidates) {
                if (!readerCandidate.isOpen()) continue;
                return readerCandidate;
            }
            return readerCandidates[0];
        }
    }

    private StatefulRedisConnection<K, V>[] getReadFromConnections(List<RedisNodeDescription> selection) {
        StatefulRedisConnection[] readerCandidates;
        try {
            readerCandidates = new StatefulRedisConnection[selection.size()];
            for (int i = 0; i < selection.size(); ++i) {
                RedisNodeDescription redisClusterNode = selection.get(i);
                RedisURI uri = redisClusterNode.getUri();
                ConnectionKey key = new ConnectionKey(redisClusterNode.getRole() == RedisInstance.Role.MASTER ? ClusterConnectionProvider.Intent.WRITE : ClusterConnectionProvider.Intent.READ, uri.getHost(), uri.getPort());
                readerCandidates[i] = (StatefulRedisConnection)this.connections.get((Object)key);
            }
        }
        catch (UncheckedExecutionException e) {
            throw new RedisException(e.getCause());
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
        return readerCandidates;
    }

    private List<RedisNodeDescription> getReadCandidates(RedisClusterNode master) {
        ArrayList candidates = Lists.newArrayList();
        for (RedisClusterNode partition : this.partitions) {
            if (!master.getNodeId().equals(partition.getNodeId()) && !master.getNodeId().equals(partition.getSlaveOf())) continue;
            candidates.add(partition);
        }
        return candidates;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String nodeId) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + nodeId + ")");
        }
        try {
            ConnectionKey key = new ConnectionKey(intent, nodeId);
            return (StatefulRedisConnection)this.connections.get((Object)key);
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String host, int port) {
        try {
            RedisClusterNode redisClusterNode;
            if (this.debugEnabled) {
                logger.debug("getConnection(" + (Object)((Object)intent) + ", " + host + ", " + port + ")");
            }
            if (this.validateClusterNodeMembership() && (redisClusterNode = this.getPartition(host, port)) == null) {
                HostAndPort hostAndPort = HostAndPort.fromParts((String)host, (int)port);
                throw this.invalidConnectionPoint(hostAndPort.toString());
            }
            ConnectionKey key = new ConnectionKey(intent, host, port);
            return (StatefulRedisConnection)this.connections.get((Object)key);
        }
        catch (UncheckedExecutionException e) {
            throw new RedisException(e.getCause());
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    private RedisClusterNode getPartition(String host, int port) {
        for (RedisClusterNode partition : this.partitions) {
            RedisURI uri = partition.getUri();
            if (port != uri.getPort() || !host.equals(uri.getHost())) continue;
            return partition;
        }
        return null;
    }

    @Override
    public void close() {
        ImmutableMap copy = ImmutableMap.copyOf((Map)this.connections.asMap());
        this.connections.invalidateAll();
        this.resetFastConnectionCache();
        for (StatefulRedisConnection kvRedisAsyncConnection : copy.values()) {
            if (!kvRedisAsyncConnection.isOpen()) continue;
            kvRedisAsyncConnection.close();
        }
    }

    @Override
    public void reset() {
        ImmutableMap copy = ImmutableMap.copyOf((Map)this.connections.asMap());
        for (StatefulRedisConnection kvRedisAsyncConnection : copy.values()) {
            kvRedisAsyncConnection.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitions(Partitions partitions) {
        Object object = this.stateLock;
        synchronized (object) {
            this.partitions = partitions;
            this.reconfigurePartitions();
        }
    }

    private void reconfigurePartitions() {
        Set<ConnectionKey> staleConnections = this.getStaleConnectionKeys();
        for (ConnectionKey key : staleConnections) {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.connections.getIfPresent((Object)key);
            RedisChannelHandler redisChannelHandler = (RedisChannelHandler)((Object)connection);
            if (!(redisChannelHandler.getChannelWriter() instanceof ClusterNodeCommandHandler)) continue;
            ClusterNodeCommandHandler clusterNodeCommandHandler = (ClusterNodeCommandHandler)redisChannelHandler.getChannelWriter();
            clusterNodeCommandHandler.prepareClose();
        }
        this.resetFastConnectionCache();
        if (this.redisClusterClient.expireStaleConnections()) {
            this.closeStaleConnections();
        }
    }

    @Override
    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        Set<ConnectionKey> stale = this.getStaleConnectionKeys();
        for (ConnectionKey connectionKey : stale) {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.connections.getIfPresent((Object)connectionKey);
            if (connection == null) continue;
            this.connections.invalidate((Object)connectionKey);
            connection.close();
        }
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    private Set<ConnectionKey> getStaleConnectionKeys() {
        HashMap map = Maps.newHashMap((Map)this.connections.asMap());
        HashSet stale = Sets.newHashSet();
        for (ConnectionKey connectionKey : map.keySet()) {
            if (connectionKey.nodeId != null && this.partitions.getPartitionByNodeId(connectionKey.nodeId) != null || connectionKey.host != null && this.getPartition(connectionKey.host, connectionKey.port) != null) continue;
            stale.add(connectionKey);
        }
        return stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        Iterator iterator = this.stateLock;
        synchronized (iterator) {
            this.autoFlushCommands = autoFlush;
        }
        for (StatefulRedisConnection connection : this.connections.asMap().values()) {
            connection.setAutoFlushCommands(autoFlush);
        }
    }

    @Override
    public void flushCommands() {
        for (StatefulRedisConnection connection : this.connections.asMap().values()) {
            connection.flushCommands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
            Arrays.fill(this.readers, null);
        }
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    protected long getConnectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetFastConnectionCache() {
        Object object = this.stateLock;
        synchronized (object) {
            Arrays.fill(this.writers, null);
            Arrays.fill(this.readers, null);
        }
    }

    private RuntimeException invalidConnectionPoint(String message) {
        return new IllegalArgumentException("Connection to " + message + " not allowed. This connection point is not known in the cluster view");
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(final ConnectionKey connectionKey) {
        return new Supplier<SocketAddress>(){

            public SocketAddress get() {
                if (connectionKey.nodeId != null) {
                    return PooledClusterConnectionProvider.this.getSocketAddress(connectionKey.nodeId);
                }
                return new InetSocketAddress(connectionKey.host, connectionKey.port);
            }
        };
    }

    protected SocketAddress getSocketAddress(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri().getResolvedAddress();
        }
        return null;
    }

    private boolean validateClusterNodeMembership() {
        return this.redisClusterClient.getClusterClientOptions() == null || this.redisClusterClient.getClusterClientOptions().isValidateClusterNodeMembership();
    }

    private class ConnectionFactory<K, V>
    extends CacheLoader<ConnectionKey, StatefulRedisConnection<K, V>> {
        private final RedisClusterClient redisClusterClient;
        private final RedisCodec<K, V> redisCodec;
        private final RedisChannelWriter<K, V> clusterWriter;

        public ConnectionFactory(RedisClusterClient redisClusterClient, RedisCodec<K, V> redisCodec, RedisChannelWriter<K, V> clusterWriter) {
            this.redisClusterClient = redisClusterClient;
            this.redisCodec = redisCodec;
            this.clusterWriter = clusterWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatefulRedisConnection<K, V> load(ConnectionKey key) throws Exception {
            StatefulRedisConnection<K, V> connection = null;
            if (key.nodeId != null) {
                if (PooledClusterConnectionProvider.this.partitions.getPartitionByNodeId(key.nodeId) == null) {
                    throw PooledClusterConnectionProvider.this.invalidConnectionPoint("node id " + key.nodeId);
                }
                connection = this.redisClusterClient.connectToNode(this.redisCodec, key.nodeId, null, (Supplier<SocketAddress>)PooledClusterConnectionProvider.this.getSocketAddressSupplier(key));
            }
            if (key.host != null) {
                if (PooledClusterConnectionProvider.this.validateClusterNodeMembership() && PooledClusterConnectionProvider.this.getPartition(key.host, key.port) == null) {
                    throw PooledClusterConnectionProvider.this.invalidConnectionPoint(key.host + ":" + key.port);
                }
                connection = this.redisClusterClient.connectToNode(this.redisCodec, key.host + ":" + key.port, this.clusterWriter, (Supplier<SocketAddress>)PooledClusterConnectionProvider.this.getSocketAddressSupplier(key));
            }
            if (key.intent == ClusterConnectionProvider.Intent.READ) {
                connection.sync().readOnly();
            }
            Object object = PooledClusterConnectionProvider.this.stateLock;
            synchronized (object) {
                connection.setAutoFlushCommands(PooledClusterConnectionProvider.this.autoFlushCommands);
            }
            return connection;
        }
    }

    private static class ConnectionKey {
        private final ClusterConnectionProvider.Intent intent;
        private final String nodeId;
        private final String host;
        private final int port;

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String nodeId) {
            this.intent = intent;
            this.nodeId = nodeId;
            this.host = null;
            this.port = 0;
        }

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String host, int port) {
            this.intent = intent;
            this.host = host;
            this.port = port;
            this.nodeId = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey key = (ConnectionKey)o;
            if (this.port != key.port) {
                return false;
            }
            if (this.intent != key.intent) {
                return false;
            }
            if (this.nodeId != null ? !this.nodeId.equals(key.nodeId) : key.nodeId != null) {
                return false;
            }
            return !(this.host == null ? key.host != null : !this.host.equals(key.host));
        }

        public int hashCode() {
            int result = this.intent != null ? this.intent.name().hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }
}

