/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Chars;
import com.lambdaworks.codec.CRC16;
import com.lambdaworks.redis.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotHash {
    public static final byte SUBKEY_START = Chars.toByteArray((char)'{')[1];
    public static final byte SUBKEY_END = Chars.toByteArray((char)'}')[1];
    public static final int SLOT_COUNT = 16384;

    private SlotHash() {
    }

    public static final int getSlot(String key) {
        return SlotHash.getSlot(key.getBytes());
    }

    public static final int getSlot(byte[] key) {
        return SlotHash.getSlot(ByteBuffer.wrap(key));
    }

    public static final int getSlot(ByteBuffer key) {
        int end;
        byte[] input = new byte[key.remaining()];
        key.duplicate().get(input);
        byte[] finalKey = input;
        int start = SlotHash.indexOf(input, SUBKEY_START);
        if (start != -1 && (end = SlotHash.indexOf(input, start + 1, SUBKEY_END)) != -1 && end != start + 1) {
            finalKey = new byte[end - (start + 1)];
            System.arraycopy(input, start + 1, finalKey, 0, finalKey.length);
        }
        return CRC16.crc16(finalKey) % 16384;
    }

    private static int indexOf(byte[] haystack, byte needle) {
        return SlotHash.indexOf(haystack, 0, needle);
    }

    private static int indexOf(byte[] haystack, int start, byte needle) {
        for (int i = start; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    static <K, V> Map<Integer, List<K>> partition(RedisCodec<K, V> codec, Iterable<K> keys) {
        HashMap partitioned = Maps.newHashMap();
        for (K key : keys) {
            int slot = SlotHash.getSlot(codec.encodeKey(key));
            if (!partitioned.containsKey(slot)) {
                partitioned.put(slot, Lists.newArrayList());
            }
            Collection list = (Collection)partitioned.get(slot);
            list.add(key);
        }
        return partitioned;
    }

    static <K> Map<K, Integer> getSlots(Map<Integer, ? extends Iterable<K>> partitioned) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Integer, Iterable<K>> entry : partitioned.entrySet()) {
            for (K key : entry.getValue()) {
                result.put(key, entry.getKey());
            }
        }
        return result;
    }
}

