/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterPartitionParser {
    public static final String CONNECTED = "connected";
    private static final String TOKEN_SLOT_IN_TRANSITION = "[";
    private static final char TOKEN_NODE_SEPARATOR = '\n';
    private static final Map<String, RedisClusterNode.NodeFlag> FLAG_MAPPING;

    private ClusterPartitionParser() {
    }

    public static Partitions parse(String nodes) {
        Partitions result = new Partitions();
        Iterator iterator = Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)nodes).iterator();
        try {
            while (iterator.hasNext()) {
                String node = (String)iterator.next();
                RedisClusterNode partition = ClusterPartitionParser.parseNode(node);
                result.addPartition(partition);
            }
        }
        catch (Exception e) {
            throw new RedisException("Cannot parse " + nodes, e);
        }
        result.updateCache();
        return result;
    }

    private static RedisClusterNode parseNode(String nodeInformation) {
        Iterable split = Splitter.on((char)' ').split((CharSequence)nodeInformation);
        Iterator iterator = split.iterator();
        String nodeId = (String)iterator.next();
        boolean connected = false;
        RedisURI uri = null;
        HostAndPort hostAndPort = HostAndPort.fromString((String)((String)iterator.next()));
        if (LettuceStrings.isNotEmpty(hostAndPort.getHostText())) {
            uri = RedisURI.Builder.redis(hostAndPort.getHostText(), hostAndPort.getPort()).build();
        }
        String flags = (String)iterator.next();
        ArrayList flagStrings = Lists.newArrayList(Splitter.on((char)',').trimResults().split((CharSequence)flags).iterator());
        Set<RedisClusterNode.NodeFlag> nodeFlags = ClusterPartitionParser.readFlags(flagStrings);
        String slaveOfString = (String)iterator.next();
        String slaveOf = "-".equals(slaveOfString) ? null : slaveOfString;
        long pingSentTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long pongReceivedTs = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        long configEpoch = ClusterPartitionParser.getLongFromIterator(iterator, 0L);
        String connectedFlags = (String)iterator.next();
        if (CONNECTED.equals(connectedFlags)) {
            connected = true;
        }
        ArrayList slotStrings = Lists.newArrayList(iterator);
        List<Integer> slots = ClusterPartitionParser.readSlots(slotStrings);
        RedisClusterNode partition = new RedisClusterNode(uri, nodeId, connected, slaveOf, pingSentTs, pongReceivedTs, configEpoch, slots, nodeFlags);
        return partition;
    }

    private static Set<RedisClusterNode.NodeFlag> readFlags(List<String> flagStrings) {
        HashSet flags = Sets.newHashSet();
        for (String flagString : flagStrings) {
            if (!FLAG_MAPPING.containsKey(flagString)) continue;
            flags.add(FLAG_MAPPING.get(flagString));
        }
        return Collections.unmodifiableSet(flags);
    }

    private static List<Integer> readSlots(List<String> slotStrings) {
        ArrayList slots = Lists.newArrayList();
        for (String slotString : slotStrings) {
            if (slotString.startsWith(TOKEN_SLOT_IN_TRANSITION)) continue;
            if (slotString.contains("-")) {
                Iterable split = Splitter.on((char)'-').split((CharSequence)slotString);
                Iterator it = split.iterator();
                int from = Integer.parseInt((String)it.next());
                int to = Integer.parseInt((String)it.next());
                for (int slot = from; slot <= to; ++slot) {
                    slots.add(slot);
                }
                continue;
            }
            slots.add(Integer.parseInt(slotString));
        }
        return Collections.unmodifiableList(slots);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return Long.parseLong((String)object);
        }
        return defaultValue;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"noflags", (Object)RedisClusterNode.NodeFlag.NOFLAGS);
        builder.put((Object)"myself", (Object)RedisClusterNode.NodeFlag.MYSELF);
        builder.put((Object)"master", (Object)RedisClusterNode.NodeFlag.MASTER);
        builder.put((Object)"slave", (Object)RedisClusterNode.NodeFlag.SLAVE);
        builder.put((Object)"fail?", (Object)RedisClusterNode.NodeFlag.EVENTUAL_FAIL);
        builder.put((Object)"fail", (Object)RedisClusterNode.NodeFlag.FAIL);
        builder.put((Object)"handshake", (Object)RedisClusterNode.NodeFlag.HANDSHAKE);
        builder.put((Object)"noaddr", (Object)RedisClusterNode.NodeFlag.NOADDR);
        FLAG_MAPPING = builder.build();
    }
}

