/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.models.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.lambdaworks.redis.models.command.CommandDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandDetailParser {
    public static final int COMMAND_INFO_SIZE = 6;
    protected static final Map<String, CommandDetail.Flag> FLAG_MAPPING;

    private CommandDetailParser() {
    }

    public static List<CommandDetail> parse(List<?> commandOutput) {
        Preconditions.checkArgument((commandOutput != null ? 1 : 0) != 0, (Object)"CommandOutput must not be null");
        ArrayList result = Lists.newArrayList();
        for (Object o : commandOutput) {
            Collection collection;
            if (!(o instanceof Collection) || (collection = (Collection)o).size() != 6) continue;
            CommandDetail commandDetail = CommandDetailParser.parseCommandDetail(collection);
            result.add(commandDetail);
        }
        return Collections.unmodifiableList(result);
    }

    private static CommandDetail parseCommandDetail(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        String name = (String)iterator.next();
        int arity = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        Object flags = iterator.next();
        int firstKey = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        int lastKey = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        int keyStepCount = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        Set<CommandDetail.Flag> parsedFlags = CommandDetailParser.parseFlags(flags);
        return new CommandDetail(name, arity, parsedFlags, firstKey, lastKey, keyStepCount);
    }

    private static Set<CommandDetail.Flag> parseFlags(Object flags) {
        HashSet result = Sets.newHashSet();
        if (flags instanceof Collection) {
            Collection collection = (Collection)flags;
            for (Object o : collection) {
                CommandDetail.Flag flag = FLAG_MAPPING.get(o);
                if (flag == null) continue;
                result.add(flag);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"admin", (Object)CommandDetail.Flag.ADMIN);
        builder.put((Object)"asking", (Object)CommandDetail.Flag.ASKING);
        builder.put((Object)"denyoom", (Object)CommandDetail.Flag.DENYOOM);
        builder.put((Object)"fast", (Object)CommandDetail.Flag.FAST);
        builder.put((Object)"loading", (Object)CommandDetail.Flag.LOADING);
        builder.put((Object)"noscript", (Object)CommandDetail.Flag.NOSCRIPT);
        builder.put((Object)"movablekeys", (Object)CommandDetail.Flag.MOVABLEKEYS);
        builder.put((Object)"pubsub", (Object)CommandDetail.Flag.PUBSUB);
        builder.put((Object)"random", (Object)CommandDetail.Flag.RANDOM);
        builder.put((Object)"readonly", (Object)CommandDetail.Flag.READONLY);
        builder.put((Object)"skip_monitor", (Object)CommandDetail.Flag.SKIP_MONITOR);
        builder.put((Object)"sort_for_script", (Object)CommandDetail.Flag.SORT_FOR_SCRIPT);
        builder.put((Object)"stale", (Object)CommandDetail.Flag.STALE);
        builder.put((Object)"write", (Object)CommandDetail.Flag.WRITE);
        FLAG_MAPPING = builder.build();
    }
}

