package com.lambdaworks.redis.sentinel.api.rx;

import java.io.Closeable;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import rx.Observable;

/**
 * Observable commands for Redis Sentinel.
 * 
 * @param <K> Key type.
 * @param <V> Value type.
 * @author Mark Paluch
 * @since 4.0
 * @generated by com.lambdaworks.apigenerator.CreateReactiveApi
 */
public interface RedisSentinelReactiveCommands<K, V> extends Closeable {

    /**
     * Return the ip and port number of the master with that name.
     * 
     * @param key the key
     * @return SocketAddress;
     */
    Observable<SocketAddress> getMasterAddrByName(K key);

    /**
     * Enumerates all the monitored masters and their states.
     * 
     * @return Map&lt;K, V&gt;&gt;
     */
    Observable<Map<K, V>> masters();

    /**
     * Show the state and info of the specified master.
     * 
     * @param key the key
     * @return Map&lt;K, V&gt;
     */
    Observable<Map<K, V>> master(K key);

    /**
     * Provides a list of slaves for the master with the specified name.
     * 
     * @param key the key
     * @return Map&lt;K, V&gt;
     */
    Observable<Map<K, V>> slaves(K key);

    /**
     * This command will reset all the masters with matching name.
     * 
     * @param key the key
     * @return Long
     */
    Observable<Long> reset(K key);

    /**
     * Perform a failover.
     * 
     * @param key the master id
     * @return String
     */
    Observable<String> failover(K key);

    /**
     * This command tells the Sentinel to start monitoring a new master with the specified name, ip, port, and quorum.
     * 
     * @param key the key
     * @param ip the IP address
     * @param port the port
     * @param quorum the quorum count
     * @return String
     */
    Observable<String> monitor(K key, String ip, int port, int quorum);

    /**
     * Multiple option / value pairs can be specified (or none at all).
     * 
     * @param key the key
     * @param option the option
     * @param value the value
     * 
     * @return String simple-string-reply {@code OK} if {@code SET} was executed correctly.
     */
    Observable<String> set(K key, String option, V value);

    /**
     * remove the specified master.
     * 
     * @param key the key
     * @return String
     */
    Observable<String> remove(K key);

    /**
     * Ping the server.
     * 
     * @return String simple-string-reply
     */
    Observable<String> ping();

    /**
     * close the underlying connection.
     */
    void close();

    /**
     *
     * @return true if the connection is open (connected and not closed).
     */
    boolean isOpen();

    /**
     *
     * @return the underlying connection.
     */
    StatefulRedisSentinelConnection<K, V> getStatefulConnection();
}
