/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;

public class GeoArgs {
    private boolean withdistance;
    private boolean withcoordinates;
    private boolean withhash;
    private Long count;
    private Sort sort = Sort.none;

    public GeoArgs withDistance() {
        this.withdistance = true;
        return this;
    }

    public GeoArgs withCoordinates() {
        this.withcoordinates = true;
        return this;
    }

    public GeoArgs withHash() {
        this.withhash = true;
        return this;
    }

    public GeoArgs withCount(long count) {
        LettuceAssert.isTrue(count > 0L, "count must be greater 0");
        this.count = count;
        return this;
    }

    public boolean isWithDistance() {
        return this.withdistance;
    }

    public boolean isWithCoordinates() {
        return this.withcoordinates;
    }

    public boolean isWithHash() {
        return this.withhash;
    }

    public GeoArgs asc() {
        return this.sort(Sort.asc);
    }

    public GeoArgs desc() {
        return this.sort(Sort.desc);
    }

    public GeoArgs sort(Sort sort) {
        LettuceAssert.notNull((Object)sort, "sort must not be null");
        this.sort = sort;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.withdistance) {
            args.add("withdist");
        }
        if (this.withhash) {
            args.add("withhash");
        }
        if (this.withcoordinates) {
            args.add("withcoord");
        }
        if (this.sort != null && this.sort != Sort.none) {
            args.add(this.sort.name());
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
    }

    public static enum Unit {
        m,
        km,
        ft,
        mi;

    }

    public static enum Sort {
        asc,
        desc,
        none;

    }
}

