/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.ClusterNodeCommandHandler;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshOptions;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshScheduler;
import com.lambdaworks.redis.cluster.PooledClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ReconnectEventListener;
import com.lambdaworks.redis.cluster.RoundRobinSocketAddressSupplier;
import com.lambdaworks.redis.cluster.StatefulRedisClusterConnectionImpl;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisAdvancedClusterCommands;
import com.lambdaworks.redis.cluster.event.ClusterTopologyChangedEvent;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.topology.ClusterTopologyRefresh;
import com.lambdaworks.redis.cluster.topology.NodeConnectionFactory;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnectionImpl;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RedisClusterClient
extends AbstractRedisClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClusterClient.class);
    protected AtomicBoolean clusterTopologyRefreshActivated = new AtomicBoolean(false);
    protected AtomicReference<ScheduledFuture<?>> clusterTopologyRefreshFuture = new AtomicReference();
    private final ClusterTopologyRefresh refresh = new ClusterTopologyRefresh(new NodeConnectionFactoryImpl(), this.getResources());
    private final ClusterTopologyRefreshScheduler clusterTopologyRefreshScheduler = new ClusterTopologyRefreshScheduler(this, this.getResources());
    private Partitions partitions;
    private final Iterable<RedisURI> initialUris;

    private RedisClusterClient() {
        this.setOptions(ClusterClientOptions.create());
        this.initialUris = Collections.emptyList();
    }

    @Deprecated
    public RedisClusterClient(RedisURI initialUri) {
        this(Collections.singletonList(RedisClusterClient.assertNotNull(initialUri)));
    }

    @Deprecated
    public RedisClusterClient(List<RedisURI> redisURIs) {
        this(null, redisURIs);
    }

    protected RedisClusterClient(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        super(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        this.initialUris = Collections.unmodifiableList(LettuceLists.newList(redisURIs));
        this.setDefaultTimeout(this.getFirstUri().getTimeout(), this.getFirstUri().getUnit());
        this.setOptions(ClusterClientOptions.builder().build());
    }

    private static void assertSameOptions(Iterable<RedisURI> redisURIs) {
        Boolean ssl = null;
        Boolean startTls = null;
        Boolean verifyPeer = null;
        for (RedisURI redisURI : redisURIs) {
            if (ssl == null) {
                ssl = redisURI.isSsl();
            }
            if (startTls == null) {
                startTls = redisURI.isStartTls();
            }
            if (verifyPeer == null) {
                verifyPeer = redisURI.isVerifyPeer();
            }
            if (ssl.booleanValue() != redisURI.isSsl()) {
                throw new IllegalArgumentException("RedisURI " + redisURI + " SSL is not consistent with the other seed URI SSL settings");
            }
            if (startTls.booleanValue() != redisURI.isStartTls()) {
                throw new IllegalArgumentException("RedisURI " + redisURI + " StartTLS is not consistent with the other seed URI StartTLS settings");
            }
            if (verifyPeer.booleanValue() == redisURI.isVerifyPeer()) continue;
            throw new IllegalArgumentException("RedisURI " + redisURI + " VerifyPeer is not consistent with the other seed URI VerifyPeer settings");
        }
    }

    public static RedisClusterClient create(RedisURI redisURI) {
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create(Collections.singleton(redisURI));
    }

    public static RedisClusterClient create(Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        return new RedisClusterClient(null, redisURIs);
    }

    public static RedisClusterClient create(String uri) {
        LettuceAssert.notNull(uri, "uri must not be null");
        return RedisClusterClient.create(RedisURI.create(uri));
    }

    public static RedisClusterClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create(clientResources, Collections.singleton(redisURI));
    }

    public static RedisClusterClient create(ClientResources clientResources, String uri) {
        RedisClusterClient.assertNotNull(clientResources);
        LettuceAssert.notNull(uri, "uri must not be null");
        return RedisClusterClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClusterClient create(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        return new RedisClusterClient(clientResources, redisURIs);
    }

    public StatefulRedisClusterConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisClusterConnection<K, V> connect(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec);
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        return this.connectClusterPubSubImpl(codec);
    }

    @Deprecated
    public RedisAdvancedClusterCommands<String, String> connectCluster() {
        return this.connectCluster(this.newStringStringCodec());
    }

    @Deprecated
    public <K, V> RedisAdvancedClusterCommands<K, V> connectCluster(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec).sync();
    }

    @Deprecated
    public RedisAdvancedClusterAsyncCommands<String, String> connectClusterAsync() {
        return this.connectClusterImpl(this.newStringStringCodec()).async();
    }

    @Deprecated
    public <K, V> RedisAdvancedClusterAsyncCommands<K, V> connectClusterAsync(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec).async();
    }

    protected StatefulRedisConnection<String, String> connectToNode(final SocketAddress socketAddress) {
        return this.connectToNode(this.newStringStringCodec(), socketAddress.toString(), null, new Supplier<SocketAddress>(){

            @Override
            public SocketAddress get() {
                return socketAddress;
            }
        });
    }

    <K, V> StatefulRedisConnection<K, V> connectToNode(RedisCodec<K, V> codec, String nodeId, RedisChannelWriter<K, V> clusterWriter, Supplier<SocketAddress> socketAddressSupplier) {
        RedisClusterClient.assertNotNull(codec);
        RedisClusterClient.assertNotEmpty(this.initialUris);
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        logger.debug("connectNode(" + nodeId + ")");
        Deque queue = LettuceFactories.newConcurrentQueue();
        ClusterNodeCommandHandler handler = new ClusterNodeCommandHandler(this.clientOptions, this.getResources(), queue, clusterWriter);
        StatefulRedisConnectionImpl connection = new StatefulRedisConnectionImpl(handler, codec, this.timeout, this.unit);
        try {
            this.connectStateful(handler, connection, this.getFirstUri(), socketAddressSupplier);
            connection.registerCloseables(this.closeableResources, connection);
        }
        catch (RedisException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    <K, V> StatefulRedisClusterConnectionImpl<K, V> connectClusterImpl(RedisCodec<K, V> codec) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        this.activateTopologyRefreshIfNeeded();
        logger.debug("connectCluster(" + this.initialUris + ")");
        Deque queue = LettuceFactories.newConcurrentQueue();
        Supplier<SocketAddress> socketAddressSupplier = this.getSocketAddressSupplier(TopologyComparators::sortByClientCount);
        CommandHandler handler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        ClusterDistributionChannelWriter clusterWriter = new ClusterDistributionChannelWriter(this.clientOptions, handler, this.clusterTopologyRefreshScheduler);
        PooledClusterConnectionProvider pooledClusterConnectionProvider = new PooledClusterConnectionProvider(this, clusterWriter, codec);
        clusterWriter.setClusterConnectionProvider(pooledClusterConnectionProvider);
        StatefulRedisClusterConnectionImpl connection = new StatefulRedisClusterConnectionImpl(clusterWriter, codec, this.timeout, this.unit);
        connection.setReadFrom(ReadFrom.MASTER);
        connection.setPartitions(this.partitions);
        boolean connected = false;
        RedisException causingException = null;
        int connectionAttempts = Math.max(1, this.partitions.size());
        for (int i = 0; i < connectionAttempts; ++i) {
            try {
                this.connectStateful(handler, connection, this.getFirstUri(), socketAddressSupplier);
                connected = true;
                break;
            }
            catch (RedisException e) {
                logger.warn(e.getMessage());
                causingException = e;
                continue;
            }
        }
        if (!connected) {
            connection.close();
            if (causingException != null) {
                throw causingException;
            }
        }
        connection.registerCloseables(this.closeableResources, connection, clusterWriter, pooledClusterConnectionProvider);
        return connection;
    }

    <K, V> StatefulRedisPubSubConnectionImpl<K, V> connectClusterPubSubImpl(RedisCodec<K, V> codec) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        this.activateTopologyRefreshIfNeeded();
        logger.debug("connectClusterPubSub(" + this.initialUris + ")");
        Deque queue = LettuceFactories.newConcurrentQueue();
        Supplier<SocketAddress> socketAddressSupplier = this.getSocketAddressSupplier(TopologyComparators::sortByClientCount);
        PubSubCommandHandler handler = new PubSubCommandHandler(this.clientOptions, this.clientResources, queue, codec);
        ClusterDistributionChannelWriter clusterWriter = new ClusterDistributionChannelWriter(this.clientOptions, handler, this.clusterTopologyRefreshScheduler);
        PooledClusterConnectionProvider pooledClusterConnectionProvider = new PooledClusterConnectionProvider(this, clusterWriter, codec);
        clusterWriter.setClusterConnectionProvider(pooledClusterConnectionProvider);
        StatefulRedisPubSubConnectionImpl connection = new StatefulRedisPubSubConnectionImpl(clusterWriter, codec, this.timeout, this.unit);
        clusterWriter.setPartitions(this.partitions);
        boolean connected = false;
        RedisException causingException = null;
        int connectionAttempts = Math.max(1, this.partitions.size());
        for (int i = 0; i < connectionAttempts; ++i) {
            try {
                this.connectStateful(handler, connection, this.getFirstUri(), socketAddressSupplier);
                connected = true;
                break;
            }
            catch (RedisException e) {
                logger.warn(e.getMessage());
                causingException = e;
                continue;
            }
        }
        if (!connected) {
            connection.close();
            throw causingException;
        }
        connection.registerCloseables(this.closeableResources, connection, clusterWriter, pooledClusterConnectionProvider);
        if (this.getFirstUri().getPassword() != null) {
            connection.async().auth(new String(this.getFirstUri().getPassword()));
        }
        return connection;
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisConnectionImpl<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        this.connectStateful0(handler, connection, connectionSettings, socketAddressSupplier);
        if (connectionSettings.getPassword() != null && connectionSettings.getPassword().length != 0) {
            connection.async().auth(new String(connectionSettings.getPassword()));
        }
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisClusterConnectionImpl<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        this.connectStateful0(handler, connection, connectionSettings, socketAddressSupplier);
        if (connectionSettings.getPassword() != null && connectionSettings.getPassword().length != 0) {
            connection.async().auth(new String(connectionSettings.getPassword()));
        }
    }

    private <K, V> void connectStateful0(CommandHandler<K, V> handler, RedisChannelHandler<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder;
        if (connectionSettings.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(connectionSettings);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.reconnectionListener(new ReconnectEventListener(this.clusterTopologyRefreshScheduler));
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, socketAddressSupplier, connectionBuilder, connectionSettings);
        this.channelType(connectionBuilder, connectionSettings);
        this.initializeChannel(connectionBuilder);
    }

    public void reloadPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
            this.partitions.updateCache();
        } else {
            Partitions loadedPartitions = this.loadPartitions();
            if (TopologyComparators.isChanged(this.getPartitions(), loadedPartitions)) {
                logger.debug("Using a new cluster topology");
                ArrayList<RedisClusterNode> before = new ArrayList<RedisClusterNode>(this.getPartitions());
                ArrayList<RedisClusterNode> after = new ArrayList<RedisClusterNode>(loadedPartitions);
                this.getResources().eventBus().publish(new ClusterTopologyChangedEvent(before, after));
            }
            this.partitions.reload(loadedPartitions.getPartitions());
        }
        this.updatePartitionsInConnections();
    }

    protected void updatePartitionsInConnections() {
        this.forEachClusterConnection(input -> input.setPartitions(this.partitions));
    }

    protected void initializePartitions() {
        Partitions loadedPartitions;
        this.partitions = loadedPartitions = this.loadPartitions();
    }

    public Partitions getPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        return this.partitions;
    }

    protected Partitions loadPartitions() {
        Iterable<RedisURI> topologyRefreshSource = this.getTopologyRefreshSource();
        Map<RedisURI, Partitions> partitions = this.refresh.loadViews(topologyRefreshSource, this.useDynamicRefreshSources());
        if (partitions.isEmpty()) {
            throw new RedisException("Cannot retrieve initial cluster partitions from initial URIs " + topologyRefreshSource);
        }
        Partitions loadedPartitions = partitions.values().iterator().next();
        RedisURI viewedBy = this.refresh.getViewedBy(partitions, loadedPartitions);
        for (RedisClusterNode partition : loadedPartitions) {
            if (viewedBy == null) continue;
            RedisURI uri = partition.getUri();
            RedisClusterClient.applyUriConnectionSettings(viewedBy, uri);
        }
        this.activateTopologyRefreshIfNeeded();
        return loadedPartitions;
    }

    private void activateTopologyRefreshIfNeeded() {
        if (this.getOptions() instanceof ClusterClientOptions) {
            ClusterClientOptions options = (ClusterClientOptions)this.getOptions();
            ClusterTopologyRefreshOptions topologyRefreshOptions = options.getTopologyRefreshOptions();
            if (!topologyRefreshOptions.isPeriodicRefreshEnabled() || this.clusterTopologyRefreshActivated.get()) {
                return;
            }
            if (this.clusterTopologyRefreshActivated.compareAndSet(false, true)) {
                ScheduledFuture scheduledFuture = this.genericWorkerPool.scheduleAtFixedRate((Runnable)this.clusterTopologyRefreshScheduler, options.getRefreshPeriod(), options.getRefreshPeriod(), options.getRefreshPeriodUnit());
                this.clusterTopologyRefreshFuture.set(scheduledFuture);
            }
        }
    }

    protected RedisURI getFirstUri() {
        RedisClusterClient.assertNotEmpty(this.initialUris);
        Iterator<RedisURI> iterator = this.initialUris.iterator();
        return iterator.next();
    }

    protected Supplier<SocketAddress> getSocketAddressSupplier(Function<Partitions, Collection<RedisClusterNode>> sortFunction) {
        LettuceAssert.notNull(sortFunction, "Sort function must not be null");
        RoundRobinSocketAddressSupplier socketAddressSupplier = new RoundRobinSocketAddressSupplier(this.partitions, sortFunction, this.clientResources);
        return () -> {
            if (this.partitions.isEmpty()) {
                SocketAddress socketAddress = SocketAddressResolver.resolve(this.getFirstUri(), this.clientResources.dnsResolver());
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)this.getFirstUri());
                return socketAddress;
            }
            return socketAddressSupplier.get();
        };
    }

    protected Utf8StringCodec newStringStringCodec() {
        return new Utf8StringCodec();
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.clusterTopologyRefreshActivated.compareAndSet(true, false)) {
            ScheduledFuture<?> scheduledFuture = this.clusterTopologyRefreshFuture.get();
            try {
                scheduledFuture.cancel(false);
                this.clusterTopologyRefreshFuture.set(null);
            }
            catch (Exception e) {
                logger.debug("Could not unschedule Cluster topology refresh", (Throwable)e);
            }
        }
        super.shutdown(quietPeriod, timeout, timeUnit);
    }

    protected void forEachClusterConnection(Consumer<StatefulRedisClusterConnectionImpl<?, ?>> function) {
        this.forEachCloseable(input -> input instanceof StatefulRedisClusterConnectionImpl, function);
    }

    protected <T extends Closeable> void forEachCloseable(Predicate<? super Closeable> selector, Consumer<T> function) {
        for (Closeable c : this.closeableResources) {
            if (!selector.test(c)) continue;
            function.accept(c);
        }
    }

    public void setOptions(ClusterClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    protected Iterable<RedisURI> getInitialUris() {
        return this.initialUris;
    }

    ClusterClientOptions getClusterClientOptions() {
        if (this.getOptions() instanceof ClusterClientOptions) {
            return (ClusterClientOptions)this.getOptions();
        }
        return null;
    }

    boolean expireStaleConnections() {
        return this.getClusterClientOptions() == null || this.getClusterClientOptions().isCloseStaleConnections();
    }

    static void applyUriConnectionSettings(RedisURI from, RedisURI to) {
        if (from.getPassword() != null && from.getPassword().length != 0) {
            to.setPassword(new String(from.getPassword()));
        }
        to.setTimeout(from.getTimeout());
        to.setUnit(from.getUnit());
        to.setSsl(from.isSsl());
        to.setStartTls(from.isStartTls());
        to.setVerifyPeer(from.isVerifyPeer());
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotEmpty(Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        LettuceAssert.isTrue(redisURIs.iterator().hasNext(), "RedisURIs must not be empty");
    }

    private static RedisURI assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
        return redisURI;
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull(clientResources, "ClientResources must not be null");
    }

    protected Iterable<RedisURI> getTopologyRefreshSource() {
        Iterable<RedisURI> seed;
        boolean initialSeedNodes;
        boolean bl = initialSeedNodes = !this.useDynamicRefreshSources();
        if (initialSeedNodes || this.partitions == null || this.partitions.isEmpty()) {
            seed = this.initialUris;
        } else {
            ArrayList<RedisURI> uris = new ArrayList<RedisURI>();
            for (RedisClusterNode partition : TopologyComparators.sortByUri(this.partitions)) {
                uris.add(partition.getUri());
            }
            seed = uris;
        }
        return seed;
    }

    protected boolean useDynamicRefreshSources() {
        if (this.getClusterClientOptions() != null) {
            ClusterTopologyRefreshOptions topologyRefreshOptions = this.getClusterClientOptions().getTopologyRefreshOptions();
            return topologyRefreshOptions.useDynamicRefreshSources();
        }
        return true;
    }

    private class NodeConnectionFactoryImpl
    implements NodeConnectionFactory {
        private NodeConnectionFactoryImpl() {
        }

        @Override
        public <K, V> StatefulRedisConnection<K, V> connectToNode(RedisCodec<K, V> codec, final SocketAddress socketAddress) {
            return RedisClusterClient.this.connectToNode(codec, socketAddress.toString(), null, new Supplier<SocketAddress>(){

                @Override
                public SocketAddress get() {
                    return socketAddress;
                }
            });
        }
    }
}

