/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.RoundRobin;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

class RoundRobinSocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RoundRobinSocketAddressSupplier.class);
    private final Collection<RedisClusterNode> partitions;
    private final Collection<RedisClusterNode> clusterNodes = new ArrayList<RedisClusterNode>();
    private final Function<Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction;
    private final ClientResources clientResources;
    private RoundRobin<? extends RedisClusterNode> roundRobin;

    public RoundRobinSocketAddressSupplier(Collection<RedisClusterNode> partitions, Function<? extends Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction, ClientResources clientResources) {
        LettuceAssert.notNull(partitions, "Partitions must not be null");
        LettuceAssert.notNull(sortFunction, "Sort-Function must not be null");
        this.partitions = partitions;
        this.clusterNodes.addAll(partitions);
        this.roundRobin = new RoundRobin<RedisClusterNode>(this.clusterNodes);
        this.sortFunction = sortFunction;
        this.clientResources = clientResources;
        this.resetRoundRobin();
    }

    @Override
    public SocketAddress get() {
        if (!this.clusterNodes.containsAll(this.partitions)) {
            this.resetRoundRobin();
        }
        RedisClusterNode redisClusterNode = this.roundRobin.next();
        return this.getSocketAddress(redisClusterNode);
    }

    protected void resetRoundRobin() {
        this.clusterNodes.clear();
        this.clusterNodes.addAll(this.sortFunction.apply(this.partitions));
        this.roundRobin.offset = null;
    }

    protected SocketAddress getSocketAddress(RedisClusterNode redisClusterNode) {
        SocketAddress resolvedAddress = SocketAddressResolver.resolve(redisClusterNode.getUri(), this.clientResources.dnsResolver());
        logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)resolvedAddress, (Object)redisClusterNode.getNodeId());
        return resolvedAddress;
    }
}

