/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.topology;

import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.topology.TimedAsyncCommand;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

class Requests {
    Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);

    Requests() {
    }

    Requests(Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews) {
        this.rawViews = rawViews;
    }

    void addRequest(RedisURI redisURI, TimedAsyncCommand<String, String, String> command) {
        this.rawViews.put(redisURI, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long waitTime = 0L;
        for (Map.Entry<RedisURI, TimedAsyncCommand<String, String, String>> entry : this.rawViews.entrySet()) {
            long timeoutLeft = timeUnit.toNanos(timeout) - waitTime;
            if (timeoutLeft <= 0L) break;
            long startWait = System.nanoTime();
            RedisFuture future = entry.getValue();
            try {
                if (future.await(timeoutLeft, TimeUnit.NANOSECONDS)) continue;
                break;
            }
            finally {
                waitTime += System.nanoTime() - startWait;
            }
        }
        return waitTime;
    }

    Set<RedisURI> nodes() {
        return this.rawViews.keySet();
    }

    TimedAsyncCommand<String, String, String> getRequest(RedisURI redisURI) {
        return this.rawViews.get(redisURI);
    }

    Requests mergeWith(Requests requests) {
        TreeMap<RedisURI, TimedAsyncCommand<String, String, String>> result = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(TopologyComparators.RedisURIComparator.INSTANCE);
        result.putAll(this.rawViews);
        result.putAll(requests.rawViews);
        return new Requests(result);
    }
}

