/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class MultiOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private final Queue<RedisCommand<K, V, ?>> queue = LettuceFactories.newSpScQueue();

    public MultiOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
    }

    public void add(RedisCommand<K, V, ?> cmd) {
        this.queue.add(cmd);
    }

    public void cancel() {
        for (RedisCommand redisCommand : this.queue) {
            redisCommand.complete();
        }
    }

    @Override
    public void set(long integer) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(integer);
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(bytes);
        }
    }

    @Override
    public void multi(int count) {
        if (count == -1 && !this.queue.isEmpty()) {
            this.queue.peek().getOutput().multi(count);
        }
    }

    @Override
    public void setError(ByteBuffer error) {
        MultiOutput output = this.queue.isEmpty() ? this : this.queue.peek().getOutput();
        output.setError(this.decodeAscii(error));
    }

    @Override
    public void complete(int depth) {
        RedisCommand<K, V, ?> cmd;
        if (this.queue.isEmpty()) {
            return;
        }
        if (depth >= 1) {
            cmd = this.queue.peek();
            cmd.getOutput().complete(depth - 1);
        }
        if (depth == 1) {
            cmd = this.queue.remove();
            CommandOutput<K, V, ?> commandOutput = cmd.getOutput();
            ((List)this.output).add(!commandOutput.hasError() ? commandOutput.get() : new RedisCommandExecutionException(commandOutput.getError()));
            cmd.complete();
        } else if (depth == 0 && !this.queue.isEmpty()) {
            for (RedisCommand redisCommand : this.queue) {
                redisCommand.complete();
            }
        }
    }
}

