/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.AbstractRedisReactiveCommands;
import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.ScanCursor;
import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.api.rx.RedisKeyReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisScriptingReactiveCommands;
import com.lambdaworks.redis.api.rx.RedisServerReactiveCommands;
import com.lambdaworks.redis.api.rx.Success;
import com.lambdaworks.redis.cluster.ClusterScanSupport;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.cluster.StatefulRedisClusterConnectionImpl;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.rx.RedisAdvancedClusterReactiveCommands;
import com.lambdaworks.redis.cluster.api.rx.RedisClusterReactiveCommands;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.output.KeyStreamingChannel;
import com.lambdaworks.redis.output.ValueStreamingChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;

public class RedisAdvancedClusterReactiveCommandsImpl<K, V>
extends AbstractRedisReactiveCommands<K, V>
implements RedisAdvancedClusterReactiveCommands<K, V> {
    private final Random random = new Random();

    public RedisAdvancedClusterReactiveCommandsImpl(StatefulRedisClusterConnectionImpl<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
    }

    @Override
    public Observable<Long> del(K ... keys) {
        return this.del((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<Long> del(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.del(keys);
        }
        ArrayList<Observable<Long>> observables = new ArrayList<Observable<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.del((Iterable)entry.getValue()));
        }
        return Observable.merge(observables).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<Long> unlink(K ... keys) {
        return this.unlink((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<Long> unlink(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.unlink(keys);
        }
        ArrayList<Observable<Long>> observables = new ArrayList<Observable<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.unlink((Iterable)entry.getValue()));
        }
        return Observable.merge(observables).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<Long> exists(K ... keys) {
        return this.exists((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<Long> exists(Iterable<K> keys) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return super.exists(keys);
        }
        ArrayList<Observable<Long>> observables = new ArrayList<Observable<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.exists((Iterable)entry.getValue()));
        }
        return Observable.merge(observables).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<V> mget(K ... keys) {
        return this.mget((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<V> mget(Iterable<K> keys) {
        List keyList = LettuceLists.newList(keys);
        Map partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.mget(keyList);
        }
        ArrayList observables = new ArrayList();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.mget((Iterable)entry.getValue()));
        }
        Observable observable = Observable.concat((Observable)Observable.from(observables));
        Observable map = observable.toList().map(vs -> {
            Object[] values = new Object[vs.size()];
            int offset = 0;
            for (Map.Entry entry : partitioned.entrySet()) {
                for (int i = 0; i < keyList.size(); ++i) {
                    int index = ((List)entry.getValue()).indexOf(keyList.get(i));
                    if (index == -1) continue;
                    values[i] = vs.get(offset + index);
                }
                offset += ((List)entry.getValue()).size();
            }
            ArrayList<Object> objects = new ArrayList<Object>(Arrays.asList(values));
            return objects;
        });
        return map.compose(new FlattenTransform());
    }

    @Override
    public Observable<Long> mget(ValueStreamingChannel<V> channel, K ... keys) {
        return this.mget(channel, (Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<Long> mget(ValueStreamingChannel<V> channel, Iterable<K> keys) {
        List<K> keyList = LettuceLists.newList(keys);
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.mget(channel, keyList);
        }
        ArrayList<Observable<Long>> observables = new ArrayList<Observable<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.mget(channel, (Iterable)entry.getValue()));
        }
        return Observable.merge(observables).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<Boolean> msetnx(Map<K, V> map) {
        return this.pipeliningWithMap(map, kvMap -> super.msetnx(kvMap), booleanObservable -> booleanObservable.reduce((accu, next) -> accu != false && next != false));
    }

    @Override
    public Observable<String> mset(Map<K, V> map) {
        return this.pipeliningWithMap(map, kvMap -> super.mset(kvMap), Observable::last);
    }

    @Override
    public Observable<K> clusterGetKeysInSlot(int slot, int count) {
        RedisClusterReactiveCommands<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterGetKeysInSlot(slot, count);
        }
        return super.clusterGetKeysInSlot(slot, count);
    }

    @Override
    public Observable<Long> clusterCountKeysInSlot(int slot) {
        RedisClusterReactiveCommands<K, V> connectionBySlot = this.findConnectionBySlot(slot);
        if (connectionBySlot != null) {
            return connectionBySlot.clusterCountKeysInSlot(slot);
        }
        return super.clusterCountKeysInSlot(slot);
    }

    @Override
    public Observable<String> clientSetname(K name) {
        ArrayList<Observable<String>> observables = new ArrayList<Observable<String>>();
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            RedisClusterReactiveCommands<K, V> byHost;
            RedisClusterReactiveCommands<K, V> byNodeId = this.getConnection(redisClusterNode.getNodeId());
            if (byNodeId.isOpen()) {
                observables.add(byNodeId.clientSetname(name));
            }
            if (!(byHost = this.getConnection(redisClusterNode.getUri().getHost(), redisClusterNode.getUri().getPort())).isOpen()) continue;
            observables.add(byHost.clientSetname(name));
        }
        return Observable.merge(observables).last();
    }

    @Override
    public Observable<Long> dbsize() {
        Map observables = this.executeOnMasters(RedisServerReactiveCommands::dbsize);
        return Observable.merge(observables.values()).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<String> flushall() {
        Map observables = this.executeOnMasters(RedisServerReactiveCommands::flushall);
        return Observable.merge(observables.values()).last();
    }

    @Override
    public Observable<String> flushdb() {
        Map observables = this.executeOnMasters(RedisServerReactiveCommands::flushdb);
        return Observable.merge(observables.values()).last();
    }

    @Override
    public Observable<K> keys(K pattern) {
        Map observables = this.executeOnMasters(commands -> commands.keys(pattern));
        return Observable.merge(observables.values());
    }

    @Override
    public Observable<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        Map observables = this.executeOnMasters(commands -> commands.keys(channel, pattern));
        return Observable.merge(observables.values()).reduce((accu, next) -> accu + next);
    }

    @Override
    public Observable<V> randomkey() {
        Partitions partitions = this.getStatefulConnection().getPartitions();
        int index = this.random.nextInt(partitions.size());
        RedisClusterReactiveCommands<K, V> connection = this.getConnection(partitions.getPartition(index).getNodeId());
        return connection.randomkey();
    }

    @Override
    public Observable<String> scriptFlush() {
        Map observables = this.executeOnNodes(RedisScriptingReactiveCommands::scriptFlush, redisClusterNode -> true);
        return Observable.merge(observables.values()).last();
    }

    @Override
    public Observable<String> scriptKill() {
        Map observables = this.executeOnNodes(RedisScriptingReactiveCommands::scriptFlush, redisClusterNode -> true);
        return Observable.merge(observables.values()).onErrorReturn(throwable -> "OK").last();
    }

    @Override
    public Observable<Success> shutdown(boolean save) {
        Map observables = this.executeOnNodes(commands -> commands.shutdown(save), redisClusterNode -> true);
        return Observable.merge(observables.values()).onErrorReturn(throwable -> null).last();
    }

    @Override
    public Observable<Long> touch(K ... keys) {
        return this.touch((Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public Observable<Long> touch(Iterable<K> keys) {
        List<K> keyList = LettuceLists.newList(keys);
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, keyList);
        if (partitioned.size() < 2) {
            return super.touch(keyList);
        }
        ArrayList<Observable<Long>> observables = new ArrayList<Observable<Long>>();
        for (Map.Entry<Integer, List<K>> entry : partitioned.entrySet()) {
            observables.add(super.touch((Iterable)entry.getValue()));
        }
        return Observable.merge(observables).reduce((accu, next) -> accu + next);
    }

    protected <T> Map<String, Observable<T>> executeOnMasters(Function<RedisClusterReactiveCommands<K, V>, Observable<T>> function) {
        return this.executeOnNodes(function, redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    protected <T> Map<String, Observable<T>> executeOnNodes(Function<RedisClusterReactiveCommands<K, V>, Observable<T>> function, Function<RedisClusterNode, Boolean> filter) {
        HashMap<String, Observable<T>> executions = new HashMap<String, Observable<T>>();
        for (RedisClusterNode redisClusterNode : this.getStatefulConnection().getPartitions()) {
            RedisURI uri;
            RedisClusterReactiveCommands<K, V> connection;
            if (!filter.apply(redisClusterNode).booleanValue() || !(connection = this.getConnection((uri = redisClusterNode.getUri()).getHost(), uri.getPort())).isOpen()) continue;
            executions.put(redisClusterNode.getNodeId(), function.apply(connection));
        }
        return executions;
    }

    private RedisClusterReactiveCommands<K, V> findConnectionBySlot(int slot) {
        RedisClusterNode node = this.getStatefulConnection().getPartitions().getPartitionBySlot(slot);
        if (node != null) {
            return this.getConnection(node.getUri().getHost(), node.getUri().getPort());
        }
        return null;
    }

    @Override
    public StatefulRedisClusterConnection<K, V> getStatefulConnection() {
        return (StatefulRedisClusterConnection)this.connection;
    }

    @Override
    public RedisClusterReactiveCommands<K, V> getConnection(String nodeId) {
        return this.getStatefulConnection().getConnection(nodeId).reactive();
    }

    @Override
    public RedisClusterReactiveCommands<K, V> getConnection(String host, int port) {
        return this.getStatefulConnection().getConnection(host, port).reactive();
    }

    @Override
    public Observable<KeyScanCursor<K>> scan() {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(scanArgs), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan((ScanCursor)cursor, scanArgs), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Observable<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan((ScanCursor)cursor), ClusterScanSupport.reactiveClusterKeyScanCursorMapper());
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.clusterScan(ScanCursor.INITIAL, (connection, cursor) -> connection.scan(channel, scanArgs), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor, scanArgs), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    @Override
    public Observable<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.clusterScan(scanCursor, (connection, cursor) -> connection.scan(channel, (ScanCursor)cursor), ClusterScanSupport.reactiveClusterStreamScanCursorMapper());
    }

    private <T extends ScanCursor> Observable<T> clusterScan(ScanCursor cursor, BiFunction<RedisKeyReactiveCommands<K, V>, ScanCursor, Observable<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<Observable<T>> resultMapper) {
        return RedisAdvancedClusterReactiveCommandsImpl.clusterScan(this.getStatefulConnection(), cursor, scanFunction, resultMapper);
    }

    static <T extends ScanCursor, K, V> Observable<T> clusterScan(StatefulRedisClusterConnection<K, V> connection, ScanCursor cursor, BiFunction<RedisKeyReactiveCommands<K, V>, ScanCursor, Observable<T>> scanFunction, ClusterScanSupport.ScanCursorMapper<Observable<T>> mapper) {
        List<String> nodeIds = ClusterScanSupport.getNodeIds(connection, cursor);
        String currentNodeId = ClusterScanSupport.getCurrentNodeId(cursor, nodeIds);
        ScanCursor continuationCursor = ClusterScanSupport.getContinuationCursor(cursor);
        Observable<T> scanCursor = scanFunction.apply(connection.getConnection(currentNodeId).reactive(), continuationCursor);
        return mapper.map(nodeIds, currentNodeId, scanCursor);
    }

    private <T> Observable<T> pipeliningWithMap(Map<K, V> map, Function<Map<K, V>, Observable<T>> function, Function<Observable<T>, Observable<T>> resultFunction) {
        Map<Integer, List<K>> partitioned = SlotHash.partition(this.codec, map.keySet());
        if (partitioned.size() < 2) {
            return function.apply(map);
        }
        List observables = partitioned.values().stream().map(ks -> {
            HashMap op = new HashMap();
            ks.forEach(k -> op.put(k, map.get(k)));
            return (Observable)function.apply(op);
        }).collect(Collectors.toList());
        return resultFunction.apply(Observable.merge(observables));
    }

    static class FlattenTransform<T>
    implements Observable.Transformer<Iterable<T>, T> {
        FlattenTransform() {
        }

        public Observable<T> call(Observable<Iterable<T>> source) {
            return source.flatMap(values -> Observable.from((Iterable)values));
        }
    }
}

