/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.ConnectionFuture;
import com.lambdaworks.redis.ConnectionPoint;
import com.lambdaworks.redis.DefaultConnectionFuture;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionStateListener;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SocketOptions;
import com.lambdaworks.redis.Transports;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.DefaultClientResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ConcurrentSet;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public abstract class AbstractRedisClient {
    protected static final PooledByteBufAllocator BUF_ALLOCATOR = PooledByteBufAllocator.DEFAULT;
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClient.class);
    @Deprecated
    protected EventLoopGroup eventLoopGroup;
    protected EventExecutorGroup genericWorkerPool;
    protected final Map<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventLoopGroup>, EventLoopGroup>(2);
    protected final HashedWheelTimer timer;
    protected final ChannelGroup channels;
    protected final ClientResources clientResources;
    protected long timeout = 60L;
    protected TimeUnit unit;
    protected ConnectionEvents connectionEvents = new ConnectionEvents();
    protected Set<Closeable> closeableResources = new ConcurrentSet();
    protected volatile ClientOptions clientOptions = ClientOptions.builder().build();
    private final boolean sharedResources;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    @Deprecated
    protected AbstractRedisClient() {
        this(null);
    }

    protected AbstractRedisClient(ClientResources clientResources) {
        if (clientResources == null) {
            this.sharedResources = false;
            this.clientResources = DefaultClientResources.create();
        } else {
            this.sharedResources = true;
            this.clientResources = clientResources;
        }
        this.unit = TimeUnit.SECONDS;
        this.genericWorkerPool = this.clientResources.eventExecutorGroup();
        this.channels = new DefaultChannelGroup(this.genericWorkerPool.next());
        this.timer = (HashedWheelTimer)this.clientResources.timer();
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T connectAsyncImpl(CommandHandler<K, V> handler, T connection, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, socketAddressSupplier, connectionBuilder, null);
        this.channelType(connectionBuilder, null);
        return this.initializeChannel(connectionBuilder);
    }

    protected void connectionBuilder(CommandHandler<?, ?> handler, RedisChannelHandler<?, ?> connection, Supplier<SocketAddress> socketAddressSupplier, ConnectionBuilder connectionBuilder, RedisURI redisURI) {
        Bootstrap redisBootstrap = new Bootstrap();
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)32768);
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)8192);
        redisBootstrap.option(ChannelOption.ALLOCATOR, (Object)BUF_ALLOCATOR);
        SocketOptions socketOptions = this.getOptions().getSocketOptions();
        redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)socketOptions.getConnectTimeoutUnit().toMillis(socketOptions.getConnectTimeout())));
        if (LettuceStrings.isEmpty(redisURI.getSocket())) {
            redisBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)socketOptions.isKeepAlive());
            redisBootstrap.option(ChannelOption.TCP_NODELAY, (Object)socketOptions.isTcpNoDelay());
        }
        connectionBuilder.timeout(redisURI.getTimeout(), redisURI.getUnit());
        connectionBuilder.password(redisURI.getPassword());
        connectionBuilder.bootstrap(redisBootstrap);
        connectionBuilder.channelGroup(this.channels).connectionEvents(this.connectionEvents).timer((Timer)this.timer);
        connectionBuilder.commandHandler(handler).socketAddressSupplier(socketAddressSupplier).connection(connection);
        connectionBuilder.workerPool(this.genericWorkerPool);
    }

    protected void channelType(ConnectionBuilder connectionBuilder, ConnectionPoint connectionPoint) {
        LettuceAssert.notNull(connectionPoint, "ConnectionPoint must not be null");
        connectionBuilder.bootstrap().group(this.getEventLoopGroup(connectionPoint));
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            connectionBuilder.bootstrap().channel(Transports.NativeTransports.domainSocketChannelClass());
        } else {
            connectionBuilder.bootstrap().channel(Transports.socketChannelClass());
        }
    }

    private synchronized EventLoopGroup getEventLoopGroup(ConnectionPoint connectionPoint) {
        if (connectionPoint.getSocket() == null && !this.eventLoopGroups.containsKey(Transports.eventLoopGroupClass())) {
            this.eventLoopGroups.put(Transports.eventLoopGroupClass(), this.clientResources.eventLoopGroupProvider().allocate(Transports.eventLoopGroupClass()));
        }
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            Class<? extends EventLoopGroup> eventLoopGroupClass = Transports.NativeTransports.eventLoopGroupClass();
            if (!this.eventLoopGroups.containsKey(Transports.NativeTransports.eventLoopGroupClass())) {
                this.eventLoopGroups.put(eventLoopGroupClass, this.clientResources.eventLoopGroupProvider().allocate(eventLoopGroupClass));
            }
        }
        if (connectionPoint.getSocket() == null) {
            return this.eventLoopGroups.get(Transports.eventLoopGroupClass());
        }
        if (connectionPoint.getSocket() != null) {
            Transports.NativeTransports.assertAvailable();
            return this.eventLoopGroups.get(Transports.NativeTransports.eventLoopGroupClass());
        }
        throw new IllegalStateException("This should not have happened in a binary decision. Please file a bug.");
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T initializeChannel(ConnectionBuilder connectionBuilder) {
        ConnectionFuture<T> connectionFuture = this.initializeChannelAsync(connectionBuilder);
        return (T)((RedisChannelHandler)this.getConnection(connectionFuture));
    }

    protected <T> T getConnection(ConnectionFuture<T> connectionFuture) {
        try {
            return connectionFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), e.getCause());
            }
            throw RedisConnectionException.create(connectionFuture.getRemoteAddress(), e);
        }
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> ConnectionFuture<T> initializeChannelAsync(ConnectionBuilder connectionBuilder) {
        SocketAddress redisAddress = connectionBuilder.socketAddress();
        if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
            throw new IllegalStateException("Cannot connect, Event executor group is terminated.");
        }
        logger.debug("Connecting to Redis at {}", (Object)redisAddress);
        CompletableFuture channelReadyFuture = new CompletableFuture();
        Bootstrap redisBootstrap = connectionBuilder.bootstrap();
        RedisChannelInitializer initializer = connectionBuilder.build();
        redisBootstrap.handler((ChannelHandler)initializer);
        this.clientResources.nettyCustomizer().afterBootstrapInitialized(redisBootstrap);
        CompletableFuture<Boolean> initFuture = initializer.channelInitialized();
        ChannelFuture connectFuture = redisBootstrap.connect(redisAddress);
        connectFuture.addListener(future -> {
            if (!future.isSuccess()) {
                logger.debug("Connecting to Redis at {}: {}", (Object)redisAddress, (Object)future.cause());
                connectionBuilder.commandHandler().initialState();
                channelReadyFuture.completeExceptionally(future.cause());
                return;
            }
            initFuture.whenComplete((success, throwable) -> {
                if (throwable == null) {
                    logger.debug("Connecting to Redis at {}: Success", (Object)redisAddress);
                    RedisChannelHandler<?, ?> connection = connectionBuilder.connection();
                    connection.registerCloseables(this.closeableResources, connection);
                    channelReadyFuture.complete(connectFuture.channel());
                    return;
                }
                logger.debug("Connecting to Redis at {}, initialization: {}", (Object)redisAddress, throwable);
                connectionBuilder.commandHandler().initialState();
                Throwable failure = throwable instanceof RedisConnectionException ? throwable : (throwable instanceof TimeoutException ? new RedisConnectionException("Could not initialize channel within " + connectionBuilder.getTimeout() + " " + (Object)((Object)connectionBuilder.getTimeUnit()), (Throwable)throwable) : throwable);
                channelReadyFuture.completeExceptionally(failure);
                CompletableFuture response = new CompletableFuture();
                response.completeExceptionally(failure);
            });
        });
        return new DefaultConnectionFuture(redisAddress, channelReadyFuture.thenApply(channel -> connectionBuilder.connection()));
    }

    public void shutdown() {
        this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        try {
            this.shutdownAsync(quietPeriod, timeout, timeUnit).get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw new RedisCommandExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw new RedisCommandExecutionException(e);
        }
    }

    public CompletableFuture<Void> shutdownAsync() {
        return this.shutdownAsync(2L, 15L, TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> shutdownAsync(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.shutdown.compareAndSet(false, true)) {
            while (!this.closeableResources.isEmpty()) {
                Closeable closeableResource = this.closeableResources.iterator().next();
                try {
                    closeableResource.close();
                }
                catch (Exception e) {
                    logger.debug("Exception on Close: " + e.getMessage(), (Throwable)e);
                }
                this.closeableResources.remove(closeableResource);
            }
            ArrayList<CompletableFuture<Void>> closeFutures = new ArrayList<CompletableFuture<Void>>();
            for (Channel c : this.channels) {
                PubSubCommandHandler psCommandHandler;
                ChannelPipeline pipeline = c.pipeline();
                CommandHandler commandHandler = (CommandHandler)pipeline.get(CommandHandler.class);
                if (commandHandler != null && !commandHandler.isClosed()) {
                    commandHandler.close();
                }
                if ((psCommandHandler = (PubSubCommandHandler)pipeline.get(PubSubCommandHandler.class)) == null || psCommandHandler.isClosed()) continue;
                psCommandHandler.close();
            }
            try {
                closeFutures.add(AbstractRedisClient.toCompletableFuture(this.channels.close()));
            }
            catch (Exception e) {
                logger.debug("Cannot close channels", (Throwable)e);
            }
            if (!this.sharedResources) {
                Future<Boolean> groupCloseFuture = this.clientResources.shutdown(quietPeriod, timeout, timeUnit);
                closeFutures.add(AbstractRedisClient.toCompletableFuture(groupCloseFuture));
            } else {
                for (EventLoopGroup eventExecutors : this.eventLoopGroups.values()) {
                    Future<Boolean> groupCloseFuture = this.clientResources.eventLoopGroupProvider().release((EventExecutorGroup)eventExecutors, quietPeriod, timeout, timeUnit);
                    closeFutures.add(AbstractRedisClient.toCompletableFuture(groupCloseFuture));
                }
            }
            return CompletableFuture.allOf(closeFutures.toArray(new CompletableFuture[closeFutures.size()]));
        }
        return CompletableFuture.completedFuture(null);
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull(listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull(listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    protected void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    private static CompletableFuture<Void> toCompletableFuture(Future<?> future) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        if (future.isDone() || future.isCancelled()) {
            if (future.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(future.cause());
            }
            return promise;
        }
        future.addListener(f -> {
            if (f.isSuccess()) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(f.cause());
            }
        });
        return promise;
    }
}

