/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class FutureSyncInvocationHandler
extends AbstractInvocationHandler {
    private final StatefulConnection<?, ?> connection;
    private final Object asyncApi;
    private final AbstractInvocationHandler.MethodTranslator translator;

    public FutureSyncInvocationHandler(StatefulConnection<?, ?> connection, Object asyncApi, Class<?>[] interfaces) {
        this.connection = connection;
        this.asyncApi = asyncApi;
        this.translator = AbstractInvocationHandler.MethodTranslator.of(asyncApi.getClass(), interfaces);
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method targetMethod = this.translator.get(method);
            Object result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (FutureSyncInvocationHandler.isNonTxControlMethod(method.getName()) && FutureSyncInvocationHandler.isTransactionActive(this.connection)) {
                    return null;
                }
                return LettuceFutures.awaitOrCancel(command, this.connection.getTimeout(), this.connection.getTimeoutUnit());
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static boolean isTransactionActive(StatefulConnection<?, ?> connection) {
        return connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti();
    }

    private static boolean isNonTxControlMethod(String methodName) {
        return !methodName.equals("exec") && !methodName.equals("multi") && !methodName.equals("discard");
    }
}

