/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.pubsub.api.sync;

import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import com.lambdaworks.redis.cluster.pubsub.api.sync.PubSubNodeSelection;
import com.lambdaworks.redis.pubsub.api.sync.RedisPubSubCommands;
import java.util.function.Predicate;

public interface RedisClusterPubSubCommands<K, V>
extends RedisPubSubCommands<K, V> {
    @Override
    public StatefulRedisClusterPubSubConnection<K, V> getStatefulConnection();

    default public PubSubNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    default public PubSubNodeSelection<K, V> slaves() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public PubSubNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public PubSubNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public PubSubNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);
}

