/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;

class RedisMasterSlaveNode
implements RedisNodeDescription {
    private final RedisURI redisURI;
    private final RedisInstance.Role role;

    RedisMasterSlaveNode(String host, int port, RedisURI seed, RedisInstance.Role role) {
        RedisURI.Builder builder = RedisURI.Builder.redis(host, port).withSsl(seed.isSsl()).withVerifyPeer(seed.isVerifyPeer()).withStartTls(seed.isStartTls());
        if (seed.getPassword() != null && seed.getPassword().length != 0) {
            builder.withPassword(new String(seed.getPassword()));
        }
        if (seed.getClientName() != null) {
            builder.withClientName(seed.getClientName());
        }
        builder.withDatabase(seed.getDatabase());
        this.redisURI = builder.build();
        this.role = role;
    }

    @Override
    public RedisURI getUri() {
        return this.redisURI;
    }

    @Override
    public RedisInstance.Role getRole() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisMasterSlaveNode)) {
            return false;
        }
        RedisMasterSlaveNode that = (RedisMasterSlaveNode)o;
        if (!this.redisURI.equals(that.redisURI)) {
            return false;
        }
        return this.role == that.role;
    }

    public int hashCode() {
        int result = this.redisURI.hashCode();
        result = 31 * result + this.role.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [redisURI=").append(this.redisURI);
        sb.append(", role=").append((Object)this.role);
        sb.append(']');
        return sb.toString();
    }
}

