/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ListSubscriber;
import com.lambdaworks.redis.output.OutputFactory;
import com.lambdaworks.redis.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ValueListOutput<K, V>
extends CommandOutput<K, V, List<V>>
implements StreamingOutput<V> {
    private boolean initialized;
    private StreamingOutput.Subscriber<V> subscriber;

    public ValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber(ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext((Collection)this.output, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<V> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<V> getSubscriber() {
        return this.subscriber;
    }
}

