/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;

public abstract class ConnectionPoolSupport {
    private ConnectionPoolSupport() {
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig config) {
        return ConnectionPoolSupport.createGenericObjectPool(connectionSupplier, config, true);
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig config, final boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        LettuceAssert.notNull(config, "GenericObjectPoolConfig must not be null");
        AtomicReference<1> poolRef = new AtomicReference<1>();
        GenericObjectPool pool = new GenericObjectPool<T>((PooledObjectFactory)new RedisPooledObjectFactory<T>(connectionSupplier), config){

            public T borrowObject() throws Exception {
                return wrapConnections ? (StatefulConnection)ConnectionPoolSupport.wrapConnection(super.borrowObject(), (ObjectPool)this) : (StatefulConnection)super.borrowObject();
            }

            public void returnObject(T obj) {
                if (wrapConnections && obj instanceof HasTargetConnection) {
                    super.returnObject(((HasTargetConnection)obj).getTargetConnection());
                    return;
                }
                super.returnObject(obj);
            }
        };
        poolRef.set(pool);
        return pool;
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier) {
        return ConnectionPoolSupport.createSoftReferenceObjectPool(connectionSupplier, true);
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier, final boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        AtomicReference<2> poolRef = new AtomicReference<2>();
        SoftReferenceObjectPool pool = new SoftReferenceObjectPool<T>((PooledObjectFactory)new RedisPooledObjectFactory<T>(connectionSupplier)){

            public T borrowObject() throws Exception {
                return wrapConnections ? (StatefulConnection)ConnectionPoolSupport.wrapConnection(super.borrowObject(), (ObjectPool)this) : (StatefulConnection)super.borrowObject();
            }

            public void returnObject(T obj) throws Exception {
                if (wrapConnections && obj instanceof HasTargetConnection) {
                    super.returnObject(((HasTargetConnection)obj).getTargetConnection());
                    return;
                }
                super.returnObject(obj);
            }
        };
        poolRef.set(pool);
        return pool;
    }

    private static <T> T wrapConnection(T connection, ObjectPool<T> pool) {
        ReturnObjectOnCloseInvocationHandler<Object> handler = new ReturnObjectOnCloseInvocationHandler<Object>(connection, pool);
        Class<?>[] implementedInterfaces = connection.getClass().getInterfaces();
        Class[] interfaces = new Class[implementedInterfaces.length + 1];
        interfaces[0] = HasTargetConnection.class;
        System.arraycopy(implementedInterfaces, 0, interfaces, 1, implementedInterfaces.length);
        Object proxiedConnection = Proxy.newProxyInstance(connection.getClass().getClassLoader(), interfaces, handler);
        handler.setProxiedConnection(proxiedConnection);
        return (T)proxiedConnection;
    }

    static interface HasTargetConnection {
        public StatefulConnection<?, ?> getTargetConnection();
    }

    private static class DelegateCloseToConnectionInvocationHandler<T extends AutoCloseable>
    extends AbstractInvocationHandler {
        private final T proxiedConnection;
        private final Object api;

        DelegateCloseToConnectionInvocationHandler(T proxiedConnection, Object api) {
            this.proxiedConnection = proxiedConnection;
            this.api = api;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            try {
                if (method.getName().equals("close")) {
                    this.proxiedConnection.close();
                    return null;
                }
                return method.invoke(this.api, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static class ReturnObjectOnCloseInvocationHandler<T>
    extends AbstractInvocationHandler {
        private T connection;
        private T proxiedConnection;
        private Map<Method, Object> connectionProxies = new ConcurrentHashMap<Method, Object>(5, 1.0f);
        private final ObjectPool<T> pool;

        ReturnObjectOnCloseInvocationHandler(T connection, ObjectPool<T> pool) {
            this.connection = connection;
            this.pool = pool;
        }

        void setProxiedConnection(T proxiedConnection) {
            this.proxiedConnection = proxiedConnection;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.connection;
            }
            if (this.connection == null) {
                throw new RedisException("Connection is deallocated and cannot be used anymore.");
            }
            if (method.getName().equals("close")) {
                this.pool.returnObject(this.proxiedConnection);
                this.connection = null;
                this.proxiedConnection = null;
                this.connectionProxies.clear();
                return null;
            }
            try {
                if (method.getName().equals("sync") || method.getName().equals("async") || method.getName().equals("reactive")) {
                    return this.connectionProxies.computeIfAbsent(method, m -> this.getInnerProxy(method, args));
                }
                return method.invoke(this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object getInnerProxy(Method method, Object[] args) {
            try {
                Object result = method.invoke(this.connection, args);
                result = Proxy.newProxyInstance(this.getClass().getClassLoader(), result.getClass().getInterfaces(), new DelegateCloseToConnectionInvocationHandler<AutoCloseable>((AutoCloseable)this.proxiedConnection, result));
                return result;
            }
            catch (IllegalAccessException e) {
                throw new RedisException(e);
            }
            catch (InvocationTargetException e) {
                throw new RedisException(e.getTargetException());
            }
        }

        public T getConnection() {
            return this.connection;
        }
    }

    private static class RedisPooledObjectFactory<T extends StatefulConnection<?, ?>>
    extends BasePooledObjectFactory<T> {
        private final Supplier<T> connectionSupplier;

        RedisPooledObjectFactory(Supplier<T> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
        }

        public T create() throws Exception {
            return (T)((StatefulConnection)this.connectionSupplier.get());
        }

        public void destroyObject(PooledObject<T> p) throws Exception {
            ((StatefulConnection)p.getObject()).close();
        }

        public PooledObject<T> wrap(T obj) {
            return new DefaultPooledObject(obj);
        }

        public boolean validateObject(PooledObject<T> p) {
            return ((StatefulConnection)p.getObject()).isOpen();
        }
    }
}

