/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.util.Misc;
import java.io.Serializable;

public class EncryptionResult
implements Serializable {
    private static final long serialVersionUID = -6451163680434801851L;
    private byte[] text;
    private byte[] iv;

    public EncryptionResult(byte[] iv, byte[] text) {
        this.text = text;
        this.iv = iv;
    }

    public EncryptionResult(byte[] simpleSerial) {
        byte ivLength = simpleSerial[0];
        int outputLength = simpleSerial.length - ivLength - 1;
        this.iv = new byte[ivLength];
        this.text = new byte[outputLength];
        System.arraycopy(simpleSerial, 1, this.iv, 0, ivLength);
        System.arraycopy(simpleSerial, ivLength + 1, this.text, 0, outputLength);
    }

    public byte[] simpleSerial() {
        byte[] out = new byte[this.text.length + this.iv.length + 1];
        out[0] = (byte)this.iv.length;
        System.arraycopy(this.iv, 0, out, 1, this.iv.length);
        System.arraycopy(this.text, 0, out, this.iv.length + 1, this.text.length);
        return out;
    }

    public byte[] getText() {
        return this.text;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public String toString() {
        return "EncryptionResult [iv=" + Misc.bytesToHex(this.iv) + "[text=" + Misc.bytesToHex(this.text) + "]\n" + Misc.bytesToHex(this.simpleSerial());
    }
}

