/*
 * Decompiled with CFR 0.152.
 */
package black.door.json;

import black.door.json.JsonArray;
import black.door.json.JsonException;
import black.door.json.JsonNull;
import black.door.json.JsonObject;
import black.door.json.JsonSerializable;
import black.door.json.tokens.StringToken;
import black.door.json.tokens.SyntaxToken;
import black.door.json.tokens.Token;
import black.door.json.tokens.ValueToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Derulo {
    protected static Object fromJSONToken(Token token) {
        if (token instanceof StringToken) {
            return token.getContent();
        }
        if (token instanceof ValueToken) {
            String content;
            switch (content = token.getContent()) {
                case "null": {
                    return JsonNull.NULL;
                }
                case "true": {
                    return Boolean.TRUE;
                }
                case "false": {
                    return Boolean.FALSE;
                }
            }
            Double number = Double.valueOf(content);
            if ((double)Math.round(number) == number) {
                return number.longValue();
            }
            return number;
        }
        throw new JsonException("Expected json value, found " + token.getContent() + "instead.");
    }

    protected static Object fromJSON(List<Token> jsonTokens) {
        Token token0 = jsonTokens.get(0);
        if (token0 == SyntaxToken.OPEN_CURL) {
            return new JsonObject(jsonTokens);
        }
        if (token0 == SyntaxToken.OPEN_SQUARE) {
            return new JsonArray(jsonTokens);
        }
        if (jsonTokens.size() == 1) {
            return Derulo.fromJSONToken(token0);
        }
        throw new JsonException("Invalid JSON");
    }

    protected static Object fromIterator(Iterator<Token> i) {
        Token value = i.next();
        if (value instanceof ValueToken || value instanceof StringToken) {
            return Derulo.fromJSONToken(value);
        }
        if (value == SyntaxToken.OPEN_CURL) {
            JsonObject obj = new JsonObject();
            obj.fromIterator(i);
            return obj;
        }
        if (value == SyntaxToken.OPEN_SQUARE) {
            JsonArray arr = new JsonArray();
            arr.fromIterator(i);
            return arr;
        }
        throw new JsonException();
    }

    public static Object fromJSON(String jsonString) {
        List<Token> tokens = Derulo.toTokens(jsonString);
        return Derulo.fromJSON(tokens);
    }

    protected static List<Token> toTokens(String jsonString) {
        ArrayList<Token> ret = new ArrayList<Token>();
        char c = jsonString.charAt(0);
        StringCharacterIterator i = new StringCharacterIterator(jsonString);
        while (c != '\uffff') {
            if (c != '\u0000' && !Character.isWhitespace(c)) {
                switch (c) {
                    case '{': {
                        ret.add(SyntaxToken.OPEN_CURL);
                        break;
                    }
                    case '}': {
                        ret.add(SyntaxToken.CLOSE_CURL);
                        break;
                    }
                    case '[': {
                        ret.add(SyntaxToken.OPEN_SQUARE);
                        break;
                    }
                    case ']': {
                        ret.add(SyntaxToken.CLOSE_SQUARE);
                        break;
                    }
                    case ':': {
                        ret.add(SyntaxToken.COLON);
                        break;
                    }
                    case ',': {
                        ret.add(SyntaxToken.COMMA);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        break;
                    }
                    case '\"': {
                        StringToken st = new StringToken();
                        StringBuilder builder = new StringBuilder();
                        c = i.next();
                        while (c != '\"') {
                            if (c == '\uffff') {
                                throw new RuntimeException();
                            }
                            if (c == '\\') {
                                i.next();
                            }
                            builder.append(c);
                            c = i.next();
                        }
                        st.setContent(builder.toString());
                        ret.add(st);
                        break;
                    }
                    default: {
                        StringBuilder sb = new StringBuilder();
                        while (!Character.isWhitespace(c) && c != ',' && c != '}' && c != ']') {
                            if (c == '\uffff') {
                                throw new RuntimeException();
                            }
                            sb.append(c);
                            c = i.next();
                        }
                        i.previous();
                        ValueToken t = new ValueToken();
                        t.setContent(sb.toString());
                        ret.add(t);
                    }
                }
            }
            c = i.next();
        }
        return ret;
    }

    public static String toJSON(JsonSerializable object) {
        return object.toJSONString();
    }

    public static String toJSON(Object object) {
        return Derulo.toJSON(0, object);
    }

    public static String toJSON(int indent, Object object) {
        return Derulo.toJSON(indent, 1, object, true).toString();
    }

    private static CharSequence toJSON(int indent, int indentLevel, Object object, boolean field) {
        try {
            Method toJsonString = object.getClass().getMethod("toJSONString", new Class[0]);
            toJsonString.setAccessible(true);
            return toJsonString.invoke(object, new Object[0]).toString();
        }
        catch (NoSuchMethodException toJsonString) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        if (object instanceof Map) {
            if (!field) {
                sb.append(Derulo.getIndents(indent * indentLevel));
            }
            sb.append("{");
            if (indent > 0) {
                sb.append('\n');
            }
            Map map = (Map)object;
            for (Map.Entry e : map.entrySet()) {
                sb.append(Derulo.getIndents(indent * indentLevel));
                sb.append("\"");
                sb.append(e.getKey().toString());
                sb.append("\":");
                if (indent > 0) {
                    sb.append(' ');
                }
                sb.append(Derulo.toJSON(indent, indentLevel + 1, e.getValue(), true));
                sb.append(",");
                if (indent <= 0) continue;
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            if (indent > 0) {
                sb.setLength(sb.length() - 1);
                sb.append('\n');
            }
            sb.append(Derulo.getIndents(indent * (indentLevel - 1)) + "}");
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (!field) {
                sb.append(Derulo.getIndents(indent * indentLevel));
            }
            sb.append("[");
            if (indent > 0) {
                sb.append('\n');
            }
            for (Object item : collection) {
                sb.append(Derulo.toJSON(indent, indentLevel, item, false));
                sb.append(",");
                if (indent <= 0) continue;
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            if (indent > 0) {
                sb.setLength(sb.length() - 1);
                sb.append('\n');
            }
            sb.append(Derulo.getIndents(indent * (indentLevel - 1)) + "]");
        } else if (object instanceof CharSequence) {
            if (!field) {
                sb.append(Derulo.getIndents(indent * indentLevel));
            }
            sb.append("\"");
            sb.append(object.toString());
            sb.append("\"");
        } else {
            if (!field) {
                sb.append(Derulo.getIndents(indent * indentLevel));
            }
            sb.append(String.valueOf(object));
        }
        return sb;
    }

    private static CharSequence getIndents(int i) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < i; ++x) {
            sb.append(" ");
        }
        return sb;
    }
}

