/*
 * Decompiled with CFR 0.152.
 */
package black.door.json;

import black.door.json.Derulo;
import black.door.json.JsonException;
import black.door.json.JsonNull;
import black.door.json.JsonObject;
import black.door.json.JsonSerializable;
import black.door.json.tokens.StringToken;
import black.door.json.tokens.SyntaxToken;
import black.door.json.tokens.Token;
import black.door.json.tokens.ValueToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonArray
extends ArrayList<Object>
implements JsonSerializable {
    public JsonArray() {
    }

    public JsonArray(String jsonString) {
        this(Derulo.toTokens(jsonString));
    }

    protected JsonArray(List<Token> jsonTokens) {
        Iterator<Token> i = jsonTokens.iterator();
        if (i.next() != SyntaxToken.OPEN_SQUARE) {
            throw new JsonException("Not a JSON array");
        }
        this.fromIterator(i);
    }

    protected void fromIterator(Iterator<Token> i) {
        Token next = i.next();
        while (i.hasNext()) {
            Token commaOrBracket;
            if (next instanceof ValueToken || next instanceof StringToken) {
                this.add(Derulo.fromJSONToken(next));
            }
            if (next == SyntaxToken.OPEN_CURL) {
                JsonObject obj = new JsonObject();
                obj.fromIterator(i);
                this.add(obj);
            }
            if (next == SyntaxToken.OPEN_SQUARE) {
                JsonArray arr = new JsonArray();
                arr.fromIterator(i);
                this.add(arr);
            }
            if ((commaOrBracket = i.next()) == SyntaxToken.CLOSE_SQUARE) break;
            if (commaOrBracket != SyntaxToken.COMMA) {
                throw new JsonException("Missing comma or closing square bracket");
            }
            next = i.next();
        }
    }

    public boolean isFieldNull(int key) {
        Object val = this.get(key);
        if (val == null) {
            return false;
        }
        return JsonNull.NULL.equals(val);
    }

    public Long getInteger(int key) {
        if (this.getFraction(key) != null) {
            return null;
        }
        try {
            return (long)((Long)this.get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String getString(int index) {
        return this.getNCast(index, String.class);
    }

    public Map getObject(int index) {
        return this.getNCast(index, Map.class);
    }

    public JsonObject getJsonObject(int index) {
        return this.getNCast(index, JsonObject.class);
    }

    public Boolean getBoolean(int index) {
        return this.getNCast(index, Boolean.class);
    }

    public Double getFraction(int index) {
        double candidate;
        try {
            candidate = (Double)this.get(index);
        }
        catch (ClassCastException e) {
            return null;
        }
        return candidate - (double)Math.round(candidate) == 0.0 ? null : Double.valueOf(candidate);
    }

    public Collection getCollection(int index) {
        return this.getNCast(index, Collection.class);
    }

    public JsonArray getArray(int index) {
        return this.getNCast(index, JsonArray.class);
    }

    private <T> T getNCast(int key, Class<T> type) {
        try {
            return type.cast(this.get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object item : this) {
            sb.append(Derulo.toJSON(item));
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

