/*
 * Decompiled with CFR 0.152.
 */
package black.door.json;

import black.door.json.Derulo;
import black.door.json.JsonArray;
import black.door.json.JsonException;
import black.door.json.JsonNull;
import black.door.json.JsonSerializable;
import black.door.json.tokens.StringToken;
import black.door.json.tokens.SyntaxToken;
import black.door.json.tokens.Token;
import black.door.json.tokens.ValueToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonObject
extends HashMap<String, Object>
implements JsonSerializable {
    public JsonObject() {
    }

    public JsonObject(String jsonString) {
        this(Derulo.toTokens(jsonString));
    }

    protected void fromIterator(Iterator<Token> i) {
        Token token = i.next();
        while (i.hasNext()) {
            Token commaOrCurl;
            if (!(token instanceof StringToken)) {
                throw new JsonException("Expected field key string, found " + token.getContent());
            }
            Token colon = i.next();
            if (colon != SyntaxToken.COLON) {
                throw new RuntimeException("Expected ':', found " + token.getContent());
            }
            Token value = i.next();
            if (value instanceof ValueToken || value instanceof StringToken) {
                this.put(token.getContent(), Derulo.fromJSONToken(value));
            }
            if (value == SyntaxToken.OPEN_CURL) {
                JsonObject obj = new JsonObject();
                obj.fromIterator(i);
                this.put(token.getContent(), obj);
            }
            if (value == SyntaxToken.OPEN_SQUARE) {
                JsonArray arr = new JsonArray();
                arr.fromIterator(i);
                this.put(token.getContent(), arr);
            }
            if ((commaOrCurl = i.next()) == SyntaxToken.CLOSE_CURL) break;
            if (commaOrCurl != SyntaxToken.COMMA) {
                throw new JsonException("Missing comma or closing curly brace");
            }
            token = i.next();
        }
    }

    protected JsonObject(List<Token> jsonTokens) {
        if (jsonTokens.get(0) != SyntaxToken.OPEN_CURL) {
            throw new JsonException("Not a JSON object");
        }
        Iterator<Token> i = jsonTokens.iterator();
        i.next();
        this.fromIterator(i);
    }

    public boolean isFieldNull(String key) {
        Object val = this.get(key);
        if (val == null && this.containsKey(key)) {
            return true;
        }
        return JsonNull.NULL.equals(val);
    }

    public Long getInteger(String key) {
        if (this.getFraction(key) != null) {
            return null;
        }
        try {
            return (long)((Long)this.get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String getString(String key) {
        return this.getNCast(key, String.class);
    }

    public Map getObject(String index) {
        return this.getNCast(index, Map.class);
    }

    public JsonObject getJsonObject(String key) {
        return this.getNCast(key, JsonObject.class);
    }

    public Boolean getBoolean(String key) {
        return this.getNCast(key, Boolean.class);
    }

    public Double getFraction(String key) {
        double candidate;
        try {
            candidate = (Double)this.get(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        return candidate - (double)Math.round(candidate) == 0.0 ? null : Double.valueOf(candidate);
    }

    public Collection getCollection(String index) {
        return this.getNCast(index, Collection.class);
    }

    public JsonArray getArray(String key) {
        return this.getNCast(key, JsonArray.class);
    }

    private <T> T getNCast(String key, Class<T> type) {
        try {
            return type.cast(this.get(key));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            sb.append("\"");
            sb.append(e.getKey().toString());
            sb.append("\":");
            sb.append(Derulo.toJSON(e.getValue()));
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }
}

