/*
 * Decompiled with CFR 0.152.
 */
package black.door.net;

import black.door.net.EchoThread;
import black.door.net.ServerThread;
import black.door.util.DBP;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Server
implements Runnable {
    private static final int DEFAULT_PORT = 1776;
    private int port;
    private ServerSocket serverSocket;
    private boolean running = false;
    private ThreadPoolExecutor pool;
    private ServerThread.ServerThreadBuilder threadBuilder;
    private BlockingQueue<Runnable> blockingQueue;
    private final int QUEUE_SIZE = 256;

    public Server(ServerThread.ServerThreadBuilder builder) {
        this(builder, 1776);
    }

    public Server(ServerThread.ServerThreadBuilder builder, int port) {
        this.port = port;
        this.blockingQueue = new ArrayBlockingQueue<Runnable>(256);
        this.pool = this.getPool();
        this.threadBuilder = builder;
    }

    public static void main(String[] args) {
        DBP.VERBOSE = true;
        Server server = new Server(new EchoThread.EchoThreadBuilder());
        server.run();
    }

    @Override
    public void run() {
        this.running = true;
        this.openServerSocket();
        while (this.isRunning()) {
            try {
                Socket sock = this.serverSocket.accept();
                ServerThread thread = this.threadBuilder.build(sock);
                if (thread == null) continue;
                this.pool.execute(thread);
            }
            catch (IOException e) {
                DBP.printerror("Could not accept socket connection!");
                DBP.printException(e);
            }
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
            }
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            DBP.printerror("Error closing Socket.");
            DBP.printException(e);
        }
        catch (InterruptedException ie) {
            DBP.printerror("Error shutting down threadpool.");
            DBP.printException(ie);
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private void openServerSocket() {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            this.running = false;
            DBP.printerror("COULD NOT OPEN SERVERSOCKET on port: " + this.port);
            DBP.printException(e);
        }
    }

    private ThreadPoolExecutor getPool() {
        int cpus = Runtime.getRuntime().availableProcessors();
        DBP.printdevln("Server Detects " + cpus + " cores.");
        int core = 5 * cpus;
        int max = 15 * cpus;
        int timeout = 60;
        TimeUnit time = TimeUnit.SECONDS;
        ThreadPoolExecutor tmp = new ThreadPoolExecutor(core, max, timeout, time, this.blockingQueue);
        return tmp;
    }
}

