/*
 * Decompiled with CFR 0.152.
 */
package black.door.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;

public class CSV {
    private int elements;
    private int fields;
    private Orientation orientation;
    private File csvFile;
    private String[][] cache;
    private boolean cached;

    public CSV(Orientation orientation) {
        this.setOrientation(orientation);
        this.elements = 0;
        this.fields = 0;
        this.cached = false;
    }

    public CSV(Orientation orientation, File csvFile) throws FileNotFoundException {
        this.setOrientation(orientation);
        this.csvFile = csvFile;
        this.findSize();
        this.cached = false;
    }

    public void cacheFile() {
        this.cache = this.orientation == Orientation.INV ? new String[this.fields][this.elements] : new String[this.elements][this.fields];
        int x = 0;
        int y = 0;
        Scanner file = null;
        try {
            file = new Scanner(this.csvFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        while (file.hasNextLine()) {
            String line = file.nextLine();
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            while (tokenizer.hasMoreTokens()) {
                this.cache[y][x] = tokenizer.nextToken();
                ++x;
            }
            x = 0;
            ++y;
        }
        file.close();
        this.cached = true;
    }

    public String getField(int x, int y) {
        boolean inRange = this.orientation == Orientation.STD ? x < this.fields && y < this.elements : y < this.fields && x < this.elements;
        if (inRange) {
            if (this.cached) {
                return this.cache[y][x];
            }
            Scanner file = null;
            try {
                file = new Scanner(this.csvFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            String line = file.nextLine();
            String field = "";
            for (int i = 0; i < y; ++i) {
                line = file.nextLine();
            }
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            for (int i = -1; i < x; ++i) {
                field = tokenizer.nextToken();
            }
            file.close();
            return field;
        }
        throw new ArrayIndexOutOfBoundsException("Field is out of bounds");
    }

    public int getElements() {
        return this.elements;
    }

    public int getFields() {
        return this.fields;
    }

    public void findSize() throws FileNotFoundException {
        if (this.csvFile != null) {
            Scanner file = new Scanner(this.csvFile);
            String line = file.nextLine();
            file.close();
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            LineNumberReader lnr = new LineNumberReader(new FileReader(this.csvFile));
            try {
                lnr.skip(Long.MAX_VALUE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int x = lnr.getLineNumber();
            try {
                lnr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.orientation == Orientation.STD) {
                this.fields = tokenizer.countTokens();
                this.elements = x + 1;
            } else {
                this.elements = tokenizer.countTokens();
                this.fields = x;
            }
        } else {
            System.out.println("csvFile not specified");
        }
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public static enum Orientation {
        STD,
        INV;

    }
}

