/*
 * Decompiled with CFR 0.152.
 */
package black.door.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineParser
implements Serializable {
    private static final long serialVersionUID = -6504238417414070778L;
    private List<List<String>> sortedArgs = new ArrayList<List<String>>();
    private ArrayList<Argument> args = new ArrayList();
    private List<Argument> params = new ArrayList<Argument>();
    private String usageHint = "";
    private String executableName = "";
    private String programDescription = "";

    @Deprecated
    public List<List<String>> getParsedArgs(String[] args) throws InvalidFormatException {
        block2: for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                if (this.params.size() > 0) {
                    ArrayList<String> option = new ArrayList<String>();
                    option.add(this.params.get((int)0).longOption);
                    this.params.remove(0);
                    option.add(args[i]);
                    this.sortedArgs.add(option);
                    continue;
                }
                throw new InvalidFormatException("Expected command line option, found " + args[i] + " instead.");
            }
            for (Argument option : this.args) {
                if (!option.matchesFlag(args[i])) continue;
                ArrayList<String> command = new ArrayList<String>();
                command.add(this.noDashes(args[i]));
                if (option.takesValue) {
                    try {
                        if (args[i + 1].startsWith("-")) {
                            if (option.valueRequired) {
                                throw new InvalidFormatException("Invalid command line format: -" + option.option + " or --" + option.longOption + " requires a parameter, found " + args[i + 1] + " instead.");
                            }
                        } else {
                            command.add(args[++i]);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                this.sortedArgs.add(command);
                continue block2;
            }
        }
        return this.sortedArgs;
    }

    public Map<String, Argument> parseArgs(String[] args) throws InvalidFormatException {
        HashMap<String, Argument> parsedArgs = new HashMap<String, Argument>();
        for (int i = 0; i < args.length; ++i) {
            String key;
            if (!args[i].startsWith("-")) {
                Argument param = null;
                for (Argument arg : this.args) {
                    if (!arg.isParam) continue;
                    param = arg;
                    break;
                }
                if (param == null) {
                    throw new InvalidFormatException(args[i] + " is a parameter, this parser does not have any parameter arguments defined.");
                }
                if (parsedArgs.containsKey(param.longOption)) {
                    if (parsedArgs.get((Object)param.longOption).multipleAllowed) {
                        parsedArgs.get(param.longOption).addValue(args[i]);
                        continue;
                    }
                    throw new InvalidFormatException(args[i] + " is a duplicate parameter, this parser is only configured to accept one value for parameter " + param.longOption);
                }
                parsedArgs.put(param.longOption, ((Argument)param.clone()).addValue(args[i]));
                continue;
            }
            boolean l = false;
            if (args[i].startsWith("--")) {
                l = true;
            }
            String form = this.noDashes(args[i]);
            Argument opt = null;
            for (Argument arg : this.args) {
                if (!(l ? form.equalsIgnoreCase(arg.longOption) : form.equals(arg.option))) continue;
                opt = arg;
                break;
            }
            if (opt == null) {
                throw new InvalidFormatException(args[i] + " is not a valid option for this parser.");
            }
            String string = key = opt.longOption == null ? opt.option : opt.longOption;
            if (parsedArgs.containsKey(key)) {
                if (parsedArgs.get((Object)key).multipleAllowed) {
                    if (!parsedArgs.get(key).takesValue()) continue;
                    if (!args[i + 1].startsWith("-")) {
                        parsedArgs.get(key).addValue(args[++i]);
                        continue;
                    }
                    if (!parsedArgs.get(key).isValueRequired()) continue;
                    throw new InvalidFormatException(args[i] + " requires a value, " + args[i + 1] + " is an option, not a value.");
                }
                throw new InvalidFormatException(args[i] + " is a duplicate option, this parser is only configured to accept one value for option " + key);
            }
            if ((opt = (Argument)opt.clone()).takesValue()) {
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    opt.addValue(args[++i]);
                } else if (opt.isValueRequired()) {
                    throw new InvalidFormatException(args[i] + " requires a value, " + (i + 1 < args.length ? args[i + 1] + " is an option, not a value." : " there should be an value after it."));
                }
            }
            parsedArgs.put(key, (Argument)opt.clone());
        }
        Set set = parsedArgs.keySet();
        for (Argument arg : this.args) {
            if (!arg.isRequiredArg() || set.contains(arg.getLongOption() == null ? arg.getOption() : arg.getLongOption())) continue;
            throw new InvalidFormatException(arg.getLongOption() == null ? arg.getOption() : arg.getLongOption() + " is a required argument, but was not included in command line.");
        }
        return parsedArgs;
    }

    public String getHelpText() {
        ArrayList arguments = (ArrayList)this.args.clone();
        String ret = this.programDescription + "\n";
        ret = ret + "Usage: " + this.executableName + " ";
        for (Argument arg : this.args) {
            if (!arg.isParam) continue;
            ret = ret + (!arg.isRequiredArg() ? "[" : "");
            ret = ret + arg.longOption;
            ret = ret + (!arg.isRequiredArg() ? "]" : "");
            ret = ret + (arg.isMultipleAllowed() ? "..." : "");
            ret = ret + " ";
            arguments.remove(arg);
        }
        for (Argument arg : arguments) {
            if (!arg.isRequiredArg()) continue;
            ret = ret + (!arg.isRequiredArg() ? "[" : "");
            ret = ret + (arg.getLongOption() == null ? "-" + arg.getOption() : "--" + arg.getLongOption());
            ret = ret + (!arg.isRequiredArg() ? "]" : "");
            ret = ret + (arg.isMultipleAllowed() ? "..." : "");
            ret = ret + " ";
        }
        ret = ret + "[OPTION]";
        ret = ret + (arguments.size() > 1 ? "... " : " ");
        ret = ret + "\n" + this.usageHint + "\n";
        ArrayList<String> col1 = new ArrayList<String>();
        ArrayList<String> col2 = new ArrayList<String>();
        for (Argument option : arguments) {
            String line = option.getOption() != null ? String.format("  %-5s", "-" + option.option + (option.getLongOption() != null ? "," : "")) : String.format("  %-5s", "");
            line = line + (option.getLongOption() != null ? "--" + option.longOption + (option.getValueHint().length() > 0 && option.takesValue() ? "=" + option.getValueHint() : "") : "");
            col1.add(line);
            col2.add(option.helpText);
        }
        ret = ret + CommandLineParser.theColumnator(col1.toArray(new String[0]), col2.toArray(new String[0]), 2, 80);
        return ret;
    }

    private static String theColumnator(String[] col1, String[] col2, int dividerSize, int pageWidth) {
        String output = "";
        int maxCol1Len = 0;
        for (String line : col1) {
            if (line.length() <= maxCol1Len) continue;
            maxCol1Len = line.length();
        }
        int col2Indent = dividerSize + maxCol1Len;
        for (int i = 0; i < col1.length; ++i) {
            output = output + CommandLineParser.theIndenter(String.format("%-" + col2Indent + "s%s\n", col1[i], col2[i]), col2Indent, pageWidth);
        }
        return output;
    }

    private static String theIndenter(String str, int indentSize, int pageWidth) {
        if (str.length() < pageWidth) {
            return str;
        }
        int columnSize = pageWidth - indentSize;
        boolean firstLine = true;
        boolean firstWord = true;
        ArrayList<String> lines = new ArrayList<String>();
        String[] input = str.split(" ");
        String line = "";
        for (int i = 0; i < input.length; ++i) {
            if (line.length() + input[i].length() <= (firstLine ? pageWidth : columnSize)) {
                line = line + (firstWord ? "" : " ") + input[i];
                firstWord = false;
                continue;
            }
            lines.add(line);
            firstLine = false;
            line = "";
            if (input[i].length() + line.length() > columnSize) {
                throw new RuntimeException("Dude, WTF is that word??");
            }
            line = line + input[i];
        }
        if (!line.equals(lines.get(lines.size() - 1)) && !line.equals("")) {
            lines.add(line);
        }
        firstLine = true;
        String out = "";
        for (String l : lines) {
            out = out + (firstLine ? "" : CommandLineParser.getLine(indentSize, ' ')) + l + '\n';
            firstLine = false;
        }
        return out;
    }

    private static String getLine(int width, char space) {
        String output = "";
        for (int i = 0; i < width; ++i) {
            output = output + space;
        }
        return output;
    }

    public void setUsageHint(String usageHint) {
        this.usageHint = usageHint;
    }

    public void setProgramDescription(String programDescription) {
        this.programDescription = programDescription;
    }

    public String getExecutableName() {
        return this.executableName;
    }

    public void setExecutableName(String executableName) {
        this.executableName = executableName;
    }

    @Deprecated
    public void addArguments(String[] argList) throws DuplicateOptionException, InvalidFormatException {
        for (String arg : argList) {
            String[] breakdown;
            Argument f = new Argument();
            for (String s : breakdown = arg.split(",")) {
                if ((s = s.trim()).startsWith("--")) {
                    f.longOption = this.noDashes(s);
                    continue;
                }
                if (s.startsWith("-h")) {
                    f.helpText = s.substring(2);
                    continue;
                }
                if (s.startsWith("-")) {
                    f.option = this.noDashes(s);
                    continue;
                }
                if (s.equals("+")) {
                    f.takesValue = true;
                    f.valueRequired = true;
                    continue;
                }
                if (s.equals("?")) {
                    f.isParam = true;
                    f.takesValue = true;
                    this.params.add(f);
                    continue;
                }
                if (s.equals("*")) {
                    f.takesValue = true;
                    continue;
                }
                throw new InvalidFormatException(s + " in " + arg + " is not formatted correctly.");
            }
            this.addArgument(f);
        }
    }

    @Deprecated
    public void addArgument(String argumentString) throws DuplicateOptionException, InvalidFormatException {
        this.addArguments(new String[]{argumentString});
    }

    @Deprecated
    public void addArgument(char shortForm, String longForm, String helpText, boolean isParameter, boolean takesValue, boolean valueRequired) throws DuplicateOptionException {
        Argument f = new Argument();
        f.option = "" + shortForm;
        f.longOption = longForm;
        f.takesValue = takesValue;
        f.valueRequired = valueRequired;
        f.helpText = helpText;
        f.isParam = isParameter;
        if (isParameter) {
            this.params.add(f);
        }
        this.addArgument(f);
    }

    public void addArgument(Argument arg) throws DuplicateOptionException {
        this.duplicateOption(arg);
        this.args.add(arg);
    }

    private void duplicateOption(Argument opt) throws DuplicateOptionException {
        for (Argument op : this.args) {
            if (opt.duplicateOptions(op)) {
                throw new DuplicateOptionException(opt);
            }
            if (!opt.isParam() || !op.isParam()) continue;
            throw DuplicateOptionException.customMessageBuilder("You can only have one parameter argument defined. You already defined " + op.getLongOption() + ". The existing parameter argument can have multiple values.");
        }
    }

    public void addArguments(Argument[] args) throws DuplicateOptionException {
        for (Argument opt : args) {
            this.addArgument(opt);
        }
    }

    private String noDashes(String s) {
        return s.replaceFirst("(--|-)", "");
    }

    public static class InvalidFormatException
    extends Exception {
        private static final long serialVersionUID = -4262637859491086870L;

        public InvalidFormatException(String s) {
            super(s);
        }
    }

    public static class DuplicateOptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DuplicateOptionException(String option) {
            super(option.length() > 1 ? "--" : "-" + option + " has already been added as an option");
        }

        public DuplicateOptionException(Argument arg) {
            super("-" + arg.option + " or " + "--" + arg.longOption + " has already been added as an option");
        }

        private DuplicateOptionException(String e, boolean x) {
            super(e);
        }

        public static DuplicateOptionException customMessageBuilder(String e) {
            return new DuplicateOptionException(e, false);
        }
    }

    public static class Argument
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 438781422325152886L;
        String option = null;
        String longOption = null;
        protected ArrayList<String> values = new ArrayList();
        String helpText = "";
        String valueHint = "";
        boolean takesValue = true;
        boolean valueRequired = false;
        boolean isParam = false;
        boolean requiredArg = false;
        boolean multipleAllowed = true;

        public Object clone() {
            Argument out = new Argument().setHelpText(this.helpText).setLongOption(this.longOption).setMultipleAllowed(this.multipleAllowed).setOption(this.option).setParam(this.isParam).setRequiredArg(this.requiredArg).setTakesValue(this.takesValue).setValueRequired(this.valueRequired);
            for (String value : this.values) {
                out.addValue(value);
            }
            return out;
        }

        public boolean duplicateOptions(Argument arg) {
            if (this.option != null && arg.getOption() != null && arg.getOption().equals(this.option)) {
                return true;
            }
            return this.longOption != null && arg.getLongOption() != null && arg.getLongOption().equals(this.longOption);
        }

        public boolean matchesFlag(String option) {
            return !this.isParam && (option.equalsIgnoreCase("--" + this.longOption) || option.equals("-" + this.option));
        }

        public String getValueHint() {
            return this.valueHint;
        }

        public Argument setValueHint(String valueHint) {
            this.valueHint = valueHint;
            return this;
        }

        public String getOption() {
            return this.option;
        }

        public Argument setOption(String option) {
            this.option = option;
            return this;
        }

        public String getLongOption() {
            return this.longOption;
        }

        public Argument setLongOption(String longOption) {
            this.longOption = longOption == null ? null : longOption.toLowerCase();
            return this;
        }

        public String getValue() {
            if (this.multipleAllowed) {
                throw new RuntimeException("This argument may have multiple values, getValue may only be used for arguments with multipleAllowed == false");
            }
            return this.values.get(0);
        }

        public ArrayList<String> getValues() {
            return this.values;
        }

        public Argument addValue(String value) {
            this.values.add(value);
            return this;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public Argument setHelpText(String helpText) {
            this.helpText = helpText;
            return this;
        }

        public boolean takesValue() {
            return this.takesValue;
        }

        public Argument setTakesValue(boolean takesValue) {
            this.takesValue = takesValue;
            return this;
        }

        public boolean isValueRequired() {
            return this.valueRequired;
        }

        public Argument setValueRequired(boolean valueRequired) {
            this.valueRequired = valueRequired;
            if (valueRequired) {
                this.takesValue = true;
            }
            return this;
        }

        public boolean isParam() {
            return this.isParam;
        }

        public Argument setParam(boolean isParam) {
            this.isParam = isParam;
            return this;
        }

        public boolean isRequiredArg() {
            return this.requiredArg;
        }

        public Argument setRequiredArg(boolean requiredArg) {
            this.requiredArg = requiredArg;
            return this;
        }

        public boolean isMultipleAllowed() {
            return this.multipleAllowed;
        }

        public Argument setMultipleAllowed(boolean multipleAllowed) {
            this.multipleAllowed = multipleAllowed;
            return this;
        }

        public String toString() {
            return "Argument [values=" + this.values + ", option=" + this.option + ", longOption=" + this.longOption + ", helpText=" + this.helpText + ", takesValue=" + this.takesValue + ", valueRequired=" + this.valueRequired + ", isParam=" + this.isParam + ", requiredArg=" + this.requiredArg + ", multipleAllowed=" + this.multipleAllowed + "]";
        }
    }
}

