/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.util.Misc;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Hash {
    public static final byte[] shuffle = new byte[]{75, -80, -87, -61, -33, 52, 124, -64, 87, -71, 17, 39, -98, 108, -110, 37, 47, -56, 112, 115, 34, -12, -115, -47, -126, -29, -75, -19, -41, 98, 125, 92, -63, 2, -31, -55, 5, -79, -82, -9, -125, -6, 116, 46, 1, -8, 117, -100, -14, -59, -74, -51, -78, 126, -99, -120, 16, 48, 101, -67, -54, 109, -16, -46, -52, -21, -13, 61, 38, 93, -89, 60, -84, -73, 68, 94, -114, 76, -123, 74, 30, 102, -121, -48, 35, -104, -62, 72, -24, 66, -117, 21, -40, 120, 121, 119, -128, 62, -34, 95, -116, -23, 73, -72, 63, 67, -109, 91, 14, -49, 110, 82, 111, -127, -76, -43, 43, 20, -108, -94, 85, -17, 65, 13, 77, -83, 70, 89, -4, -88, 105, -113, -38, -10, -93, 26, -65, -25, -111, 18, 69, 32, -66, 10, 22, -53, -103, 28, 123, 27, 71, -107, -57, 24, -69, 88, 19, 107, -70, -112, -77, 50, 23, -119, -122, 55, -124, -18, -91, 31, -97, -44, 15, -27, 33, -26, 56, -5, 97, -42, 78, -106, -45, -68, -50, 11, 79, -37, 3, 53, 80, 86, -81, -58, -20, 44, -105, -102, -86, -95, 8, 99, 6, -7, 59, 51, -28, 106, 96, 45, 103, 113, -35, 114, -30, -2, 7, 58, 25, 41, 0, 29, 104, 84, 42, -32, -3, 9, 81, 12, 57, 4, 127, -1, -90, 40, -11, -15, 122, -96, 83, -118, -85, 118, 36, 90, -36, 64, -22, -60, -101, -39, 49, 54, -92, 100};
    private static MessageDigest SHA256_INSTANCE = null;

    public static byte[] getFileHash(File file) throws IOException {
        int k;
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream inStream = new BufferedInputStream(fis);
        byte[] buffer = new byte[32];
        MessageDigest mD = null;
        try {
            mD = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        while ((k = inStream.read(buffer)) != -1) {
            mD.update(Arrays.copyOf(buffer, k));
        }
        inStream.close();
        return mD.digest();
    }

    public static byte[] shuffle(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            int i2 = input[i];
            if (i2 < 0) {
                i2 = 127 + Math.abs(i2);
            }
            input[i] = shuffle[i2];
        }
        return input;
    }

    private static byte[] getHash(String algorithm, byte[] input) {
        MessageDigest mD = null;
        try {
            mD = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        mD.update(input);
        return mD.digest();
    }

    @Deprecated
    public static byte[] getSHA1(byte[] input) {
        return Hash.getHash("SHA-1", input);
    }

    @Deprecated
    public static String getSHA1String(byte[] input) {
        return Misc.bytesToHex(Hash.getSHA1(input));
    }

    public static byte[] getSHA256(byte[] input) {
        return Hash.getSHA256(input, false);
    }

    public static byte[] getSHA256(byte[] input, boolean asSingleton) {
        if (SHA256_INSTANCE == null) {
            if (asSingleton) {
                try {
                    SHA256_INSTANCE = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            } else {
                return Hash.getHash("SHA-256", input);
            }
        }
        return SHA256_INSTANCE.digest(input);
    }

    public static byte[] getStretchedSHA256(byte[] input, byte[] salt, int length) {
        MessageDigest mD = null;
        try {
            mD = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] output = new byte[32];
        System.arraycopy(input, 0, output, 0, input.length);
        while (length-- > 0) {
            output = Hash.shuffle(output);
            output = mD.digest(Misc.XOR(output, salt));
        }
        return output;
    }

    @Deprecated
    public static String getSHA256String(byte[] input) {
        return Misc.bytesToHex(Hash.getSHA256(input));
    }
}

