/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.crypto.Exceptions;
import black.door.struct.ByteQueue;
import black.door.util.Misc;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SHE {
    protected int blockSize;
    protected int keySize;
    private int blockNo = 0;
    private boolean cfg = false;
    private byte[] key;
    private ByteQueue buffer;
    private MessageDigest mD;
    private byte[] prehash;

    public static SHE getInstance() {
        try {
            return new SHE("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SHE getInstance(String algorithm) throws NoSuchAlgorithmException {
        return new SHE(algorithm);
    }

    protected SHE(String algorithm) throws NoSuchAlgorithmException {
        this.mD = MessageDigest.getInstance(algorithm);
        this.blockSize = this.mD.getDigestLength();
    }

    public boolean isConfigured() {
        return this.cfg;
    }

    public byte[] init(byte[] key) {
        this.keySize = key.length;
        byte[] iv = new byte[this.keySize];
        new SecureRandom().nextBytes(iv);
        this.init(iv, key);
        return iv;
    }

    public void init(byte[] IV, byte[] key) {
        if (IV.length != key.length) {
            throw new Exceptions.InvalidKeyException("Key and IV size must be equal.");
        }
        this.keySize = key.length;
        this.key = key;
        this.prehash = Misc.cleanXOR(IV, key);
        this.blockNo = 0;
        this.buffer = new ByteQueue(this.blockSize * 2);
        this.buffer.setResizable(true);
        this.cfg = true;
    }

    public byte[] update(byte[] input) {
        if (!this.cfg) {
            throw new Exceptions.CipherNotInitializedException();
        }
        if (input.length == 0) {
            return null;
        }
        if (input.length > this.buffer.capacity()) {
            this.buffer.resize(input.length + this.blockSize);
        }
        while (this.buffer.filled() < input.length) {
            this.bufferKeystream();
        }
        return Misc.XORintoA(this.buffer.deQueue(input.length), input);
    }

    public void zeroKey() {
        int i;
        for (i = 0; i < this.key.length; ++i) {
            this.key[i] = 0;
        }
        for (i = 0; i < this.prehash.length; ++i) {
            this.key[i] = 0;
        }
        this.cfg = false;
    }

    protected void bufferKeystream() {
        int i = this.blockNo % this.keySize;
        int inc = this.blockNo / this.keySize + 1;
        int n = i;
        this.prehash[n] = (byte)(this.prehash[n] ^ this.key[i]);
        int n2 = i;
        this.prehash[n2] = (byte)(this.prehash[n2] + inc);
        int n3 = i;
        this.prehash[n3] = (byte)(this.prehash[n3] ^ this.key[i]);
        this.buffer.enQueue(this.mD.digest(this.prehash));
        int n4 = i;
        this.prehash[n4] = (byte)(this.prehash[n4] ^ this.key[i]);
        int n5 = i;
        this.prehash[n5] = (byte)(this.prehash[n5] - inc);
        int n6 = i;
        this.prehash[n6] = (byte)(this.prehash[n6] ^ this.key[i]);
        ++this.blockNo;
    }
}

