/*
 * Decompiled with CFR 0.152.
 */
package black.door.crypto;

import black.door.crypto.Cipher;
import black.door.crypto.Exceptions;
import black.door.struct.ByteQueue;
import black.door.util.Misc;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SHECipher
implements Cipher {
    public static final int MIN_KEY_SIZE = 8;
    private int blockNo = 0;
    private boolean cfg = false;
    private byte[] key;
    private ByteQueue buffer;
    private MessageDigest mD;
    private IvParameterSpec iv;
    private byte[] prehash;

    public static SHECipher getDefaultInstance() {
        try {
            return new SHECipher(MessageDigest.getInstance("SHA-256"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SHECipher(MessageDigest mD) {
        this.mD = mD;
    }

    public boolean isConfigured() {
        return this.cfg;
    }

    @Override
    public String getAlgorithm() {
        return this.mD.getAlgorithm();
    }

    @Override
    public byte[] getIV() {
        return this.iv.getIV();
    }

    public IvParameterSpec init(SecretKey key) throws InvalidKeyException {
        byte[] iv = new byte[key.getEncoded().length];
        new SecureRandom().nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        this.init(key, ivSpec);
        return ivSpec;
    }

    @Override
    public void init(Key key, IvParameterSpec iv) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException();
        }
        int ivLength = iv.getIV().length;
        if (key.getEncoded().length < 8 || key.getEncoded().length < ivLength) {
            throw new InvalidKeyException("Key must be longer than 8 bytes and key must be longer than IV.");
        }
        this.key = key.getEncoded();
        this.iv = iv;
        this.prehash = Misc.XORintoA(this.key.length == ivLength ? iv.getIV() : Arrays.copyOf(iv.getIV(), this.key.length), this.key);
        this.blockNo = 0;
        this.buffer = new ByteQueue(this.getBlockSize() * 2);
        this.buffer.setResizable(true);
        this.cfg = true;
    }

    @Override
    public int getBlockSize() {
        return this.mD.getDigestLength();
    }

    public void reset() {
        this.cfg = false;
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.prehash, (byte)0);
        this.buffer = null;
        this.mD.reset();
    }

    @Override
    public byte[] update(byte[] input) {
        if (!this.cfg) {
            throw new Exceptions.CipherNotInitializedException();
        }
        if (input.length == 0) {
            return null;
        }
        if (input.length > this.buffer.capacity()) {
            this.buffer.resize(input.length + this.getBlockSize());
        }
        while (this.buffer.filled() < input.length) {
            this.bufferKeystream();
        }
        return Misc.XORintoA(this.buffer.deQueue(input.length), input);
    }

    protected void bufferKeystream() {
        int i = this.blockNo % this.key.length;
        int inc = this.blockNo / this.key.length + 1;
        int n = i;
        this.prehash[n] = (byte)(this.prehash[n] ^ this.key[i]);
        int n2 = i;
        this.prehash[n2] = (byte)(this.prehash[n2] + inc);
        int n3 = i;
        this.prehash[n3] = (byte)(this.prehash[n3] ^ this.key[i]);
        this.buffer.enQueue(this.mD.digest(this.prehash));
        int n4 = i;
        this.prehash[n4] = (byte)(this.prehash[n4] ^ this.key[i]);
        int n5 = i;
        this.prehash[n5] = (byte)(this.prehash[n5] - inc);
        int n6 = i;
        this.prehash[n6] = (byte)(this.prehash[n6] ^ this.key[i]);
        ++this.blockNo;
    }
}

