/*
 * Decompiled with CFR 0.152.
 */
package black.door.util;

import black.door.util.Misc;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@Deprecated
public enum DBP {
    INSTANCE;

    private Map<String, Channel> channels;
    private static final String DEFAULT_LOG_FILE = "log.log";
    public static boolean LOG_ALL;
    public static boolean VERBOSE;
    private PrintStream out = System.out;
    private PrintStream log;

    private static Map<String, Channel> getChannels() {
        return DBP.INSTANCE.channels;
    }

    private DBP() {
        this.channels = new ConcurrentHashMap<String, Channel>();
        Channel debug = new Channel("DEBUG", System.out);
        debug.setEnabled(false);
        Channel error = new Channel("ERROR", System.err);
        Channel dev = new Channel("DEV", System.out);
        dev.disable();
        Channel demo = new Channel("DEMO", System.out);
        demo.disable();
        Channel warning = new Channel("WARNING", System.out);
        warning.disable();
        Channel log = null;
        try {
            log = new Channel("LOG", new PrintStream(DEFAULT_LOG_FILE));
            log.disable();
            this.channels.put(log.getName(), log);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("log.log could not be created.");
        }
        this.channels.put(debug.getName(), debug);
        this.channels.put(error.getName(), error);
        this.channels.put(dev.getName(), dev);
        this.channels.put(demo.getName(), demo);
        this.channels.put(warning.getName(), warning);
    }

    public static void addChannel(String name, OutputStream stream) {
        DBP.addChannel(name, stream, true);
    }

    public static void addChannel(String name, OutputStream stream, boolean enabled) {
        Channel c = new Channel(name, stream);
        c.enabled = enabled;
        DBP.addChannel(c);
    }

    public static void addChannel(Channel channel) {
        if (DBP.INSTANCE.channels.containsKey(channel.getName())) {
            throw new ChannelAlreadyExistsException();
        }
        DBP.INSTANCE.channels.put(channel.getName(), channel);
    }

    public static Channel removeChannel(String channel) {
        return DBP.INSTANCE.channels.remove(channel);
    }

    public static Channel getChannel(String channel) {
        if (!DBP.INSTANCE.channels.containsKey(channel.toUpperCase())) {
            throw new ChannelNotFoundException();
        }
        return DBP.INSTANCE.channels.get(channel.toUpperCase());
    }

    public static Channel getChannel(DefaultChannelNames channel) {
        return DBP.getChannel(channel.name());
    }

    public static OutputStream getChannelStream(String channel) {
        Channel c = DBP.getChannels().get(channel.toUpperCase());
        if (c == null) {
            throw new ChannelNotFoundException();
        }
        return c.pStream;
    }

    public static boolean enableChannel(String channel) {
        Channel c = DBP.getChannel(channel);
        boolean old = c.isEnabled();
        c.setEnabled(true);
        return old;
    }

    public static boolean disableChannel(String channel) {
        Channel c = DBP.getChannel(channel);
        boolean old = c.isEnabled();
        c.setEnabled(false);
        return old;
    }

    public static void println(String channel, Object ... e) {
        if (DBP.INSTANCE.channels.containsKey(channel.toUpperCase())) {
            DBP.getChannel(channel).print(e);
        } else {
            DBP.println(DefaultChannelNames.ERROR.toString(), "unknown DBP channel: " + channel + " at " + Thread.currentThread().getStackTrace()[2]);
        }
    }

    public static void printlog(Object e) {
        DBP.println("LOG", e);
    }

    public static void printlogln(Object e) {
        DBP.printlog(String.valueOf(e) + '\n');
    }

    public static void printdebug(Object e) {
        DBP.println("DEBUG", e);
    }

    public static void printdebugln(Object e) {
        DBP.printdebug(String.valueOf(e) + '\n');
    }

    public static void printException(Exception e) {
        DBP.printerrorln(e);
        for (StackTraceElement elem : e.getStackTrace()) {
            DBP.printerrorln("  at " + elem);
        }
    }

    public static void printerror(Object e) {
        DBP.println("ERROR", e);
    }

    public static void printerrorln(Object e) {
        DBP.printerror(String.valueOf(e));
    }

    public static void printdev(Object e) {
        DBP.println("DEV", e);
    }

    public static void printdevln(Object e) {
        DBP.printdev(String.valueOf(e) + '\n');
    }

    public static void printdemo(Object e) {
        DBP.println("DEMO", e);
    }

    public static void printdemoln(Object e) {
        DBP.printdemo(String.valueOf(e) + '\n');
    }

    public static void printwarning(Object e) {
        DBP.println("WARNING", e);
    }

    public static void printwarningln(Object e) {
        DBP.printwarning(String.valueOf(e) + '\n');
    }

    public static boolean toggleDebug() {
        Channel debug;
        debug.setEnabled(!(debug = DBP.getChannel("DEBUG")).isEnabled());
        return debug.isEnabled();
    }

    public static boolean toggleDemo() {
        Channel c;
        c.setEnabled(!(c = DBP.getChannel(DefaultChannelNames.DEMO.name())).isEnabled());
        return c.isEnabled();
    }

    public static boolean toggleDev() {
        Channel c;
        c.setEnabled(!(c = DBP.getChannel(DefaultChannelNames.DEV.name())).isEnabled());
        return c.isEnabled();
    }

    public static boolean toggleError() {
        Channel c;
        c.setEnabled(!(c = DBP.getChannel(DefaultChannelNames.ERROR.name())).isEnabled());
        return c.isEnabled();
    }

    public static boolean toggleLog() {
        Channel c;
        c.setEnabled(!(c = DBP.getChannel(DefaultChannelNames.LOG.name())).isEnabled());
        return c.isEnabled();
    }

    public static boolean toggleWarning() {
        Channel c;
        c.setEnabled(!(c = DBP.getChannel(DefaultChannelNames.WARNING.name())).isEnabled());
        return c.isEnabled();
    }

    public static boolean toggleVerbose() {
        VERBOSE = !VERBOSE;
        return VERBOSE;
    }

    public static void setLogFileLocation(String logFile) throws FileNotFoundException {
        DBP.getChannel(DefaultChannelNames.LOG).setOutputStream(new PrintStream(logFile), true);
    }

    static {
        LOG_ALL = false;
        VERBOSE = false;
    }

    private static class ChannelAlreadyExistsException
    extends RuntimeException {
        public ChannelAlreadyExistsException() {
            super("The channel you specified already exists. Remove it or modify its settings.");
        }
    }

    private static class ChannelNotFoundException
    extends RuntimeException {
        public ChannelNotFoundException() {
            super("The channel you specified is not recognized. Check spelling or create it.");
        }
    }

    public static class Channel {
        private String name;
        private boolean enabled;
        private boolean printAsJson;
        private boolean log;
        private boolean neverLog;
        private boolean printStack;
        private boolean printLine;
        private PrintStream pStream;

        public Channel(String name, OutputStream stream) {
            this.name = name.toUpperCase();
            this.setOutputStream(stream);
            this.enabled = true;
            this.printAsJson = false;
            this.log = false;
            this.printStack = false;
            this.printLine = false;
            this.neverLog = false;
        }

        private void print(Object ... o) {
            if (this.enabled || VERBOSE) {
                String formatted = this.getFormatted(o);
                this.pStream.print(formatted);
                if ((this.log || LOG_ALL) && !this.neverLog) {
                    ((Channel)DBP.getChannels().get((Object)"LOG")).pStream.print(formatted);
                }
            }
        }

        private String getFormatted(Object ... o) {
            StringBuilder sb = new StringBuilder();
            String time = Misc.getISO8601ZULUTime();
            StackTraceElement line = null;
            if (this.printLine) {
                line = Thread.currentThread().getStackTrace()[5];
            }
            if (this.printAsJson) {
                JSONObject js = new JSONObject();
                js.put("timestamp", (Object)time);
                js.put("channel", (Object)this.name);
                if (this.printLine) {
                    js.put("line", (Object)line);
                }
                JSONArray arr = new JSONArray((Object)o);
                js.put("message", (Object)arr);
                sb.append(js);
                sb.append('\n');
            } else {
                String header = "[" + time + "]" + String.format("[%-7s] ", this.name);
                StringBuilder sb2 = new StringBuilder();
                for (Object obj : o) {
                    sb2.append(String.valueOf(obj));
                }
                if (this.printStack) {
                    StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                    sb2.append('\n');
                    for (int i = 5; i < stack.length; ++i) {
                        sb2.append("  at " + stack[i] + '\n');
                    }
                }
                Scanner scan = new Scanner(sb2.toString());
                while (scan.hasNextLine()) {
                    sb.append(header + scan.nextLine());
                    if (this.printLine && !this.printStack) {
                        sb.append(" at " + line);
                    }
                    sb.append('\n');
                }
                scan.close();
            }
            return sb.toString();
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrintingLine() {
            return this.printLine;
        }

        public void setPrintLine(boolean printLine) {
            this.printLine = printLine;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isPrintingStack() {
            return this.printStack;
        }

        public void setPrintStack(boolean printStack) {
            this.printStack = printStack;
        }

        public boolean enable() {
            boolean temp = this.enabled;
            this.enabled = true;
            return temp;
        }

        public boolean disable() {
            boolean temp = this.enabled;
            this.enabled = false;
            return temp;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean printsAsJson() {
            return this.printAsJson;
        }

        public void printAsJson(boolean printAsJson) {
            this.printAsJson = printAsJson;
        }

        public boolean isLogging() {
            return this.log;
        }

        public void setNeverLog(boolean b) {
            this.neverLog = b;
        }

        public boolean getNeverLog() {
            return this.neverLog;
        }

        public void setLogging(boolean log) {
            this.log = log;
        }

        public OutputStream getOutputStream() {
            return this.pStream;
        }

        public void setOutputStream(OutputStream stream) {
            this.pStream = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
        }

        public void setOutputStream(OutputStream stream, boolean close) {
            if (this.pStream != null && close) {
                this.pStream.close();
            }
            this.setOutputStream(stream);
        }

        public String toString() {
            return "Channel [name=" + this.name + ", enabled=" + this.enabled + ", printingAsJson=" + this.printAsJson + ", logging=" + this.log + ", printStream=" + this.pStream + "]";
        }
    }

    public static enum DefaultChannelNames {
        DEBUG,
        ERROR,
        DEV,
        DEMO,
        WARNING,
        LOG;

    }
}

