/*
 * Decompiled with CFR 0.152.
 */
package black.door.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public abstract class Misc {
    public static final String CLRF = "\r\n";
    public static final DateFormat ISO8601ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final char NULL = '\u0000';
    protected static final char[] hexArray;

    public static String arrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (Object o : array) {
            sb.append(String.valueOf(o));
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(" ]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getISO8601ZULUTime() {
        DateFormat dateFormat = ISO8601ZULU;
        synchronized (dateFormat) {
            return ISO8601ZULU.format(new Date());
        }
    }

    public static Constructor getZeroParamConstructor(Class c) throws SecurityException, NoSuchMethodException {
        Constructor<?>[] constructors;
        for (Constructor<?> con : constructors = c.getConstructors()) {
            if (con.getParameterCount() != 0) continue;
            if (!con.isAccessible()) {
                con.setAccessible(true);
            }
            return con;
        }
        throw new NoSuchMethodException("Could not find a zero parameter constructor for " + c.getCanonicalName());
    }

    public static int getHammingDistance(byte[] a, byte[] b) {
        int i;
        int d = 0;
        for (i = 0; i < Math.min(a.length, b.length); ++i) {
            d += Misc.bitCount((byte)(a[i] ^ b[i]));
        }
        while (i < Math.max(a.length, b.length)) {
            d += Misc.bitCount(a.length > b.length ? a[i] : b[i]);
            ++i;
        }
        return d;
    }

    public static byte[] v426(byte[] v4) {
        if (v4.length != 4) {
            throw new RuntimeException("v4 must be 4 bytes that represent an IPv4 address.");
        }
        byte[] v6 = new byte[16];
        System.arraycopy(v4, 0, v6, 12, 4);
        System.arraycopy(new byte[]{-1, -1}, 0, v6, 10, 2);
        return v6;
    }

    public static int getCardinalXOR(byte[] a, byte[] b) {
        BitSet aSet = BitSet.valueOf(a);
        aSet.xor(BitSet.valueOf(b));
        return aSet.cardinality();
    }

    public static int bitCount(byte i) {
        i = (byte)(i - (i >>> 1 & 0x55555555));
        i = (byte)((i & 0x33333333) + (i >>> 2 & 0x33333333));
        i = (byte)(i + (i >>> 4) & 0xF0F0F0F);
        i = (byte)(i + (i >>> 8));
        i = (byte)(i + (i >>> 16));
        return i & 0x3F;
    }

    public static byte[] getNumberInBytes(Integer num) {
        byte[] result = new byte[4];
        for (int i = 0; i < result.length; ++i) {
            int x = 32 - (8 + 8 * i);
            result[i] = (byte)(num >> x);
        }
        return result;
    }

    public static byte[] getNumberInBytes(Long num) {
        byte[] result = new byte[8];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(num >> 64 - (8 + 8 * i));
        }
        return result;
    }

    public static void PrintMemInfo(Runtime runtime) {
        int mb = 0x100000;
        System.out.println("Used Memory:" + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        System.out.println("Free Memory:" + runtime.freeMemory() / (long)mb);
        System.out.println("Total Memory:" + runtime.totalMemory() / (long)mb);
    }

    public static String getHexBytes(byte[] in, String space) {
        String hexChars = "";
        for (int j = 0; j < in.length; ++j) {
            int v = in[j] & 0xFF;
            hexChars = hexChars + hexArray[v >>> 4];
            hexChars = hexChars + hexArray[v & 0xF];
            hexChars = hexChars + space;
        }
        return hexChars.substring(0, hexChars.length() - space.length());
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] serialize(Serializable s) throws IOException {
        ByteArrayOutputStream byteOutS = new ByteArrayOutputStream();
        ObjectOutputStream objOutS = new ObjectOutputStream(byteOutS);
        objOutS.writeObject(s);
        byte[] out = byteOutS.toByteArray();
        objOutS.close();
        return out;
    }

    public static byte[] XOR(byte[] array1, byte[] array2) {
        boolean trueIfOne;
        int length;
        if (array1.length >= array2.length) {
            length = array1.length;
            trueIfOne = true;
        } else {
            length = array2.length;
            trueIfOne = false;
        }
        byte[] array3 = new byte[length];
        int i = 0;
        if (trueIfOne) {
            for (byte a : array2) {
                array3[i] = (byte)(a ^ array1[i++]);
            }
            System.arraycopy(array1, i, array3, i, length - i);
        } else {
            for (byte a : array1) {
                array3[i] = (byte)(a ^ array2[i++]);
            }
            System.arraycopy(array2, i, array3, i, length - i);
        }
        return array3;
    }

    public static byte[] XOR2(byte[] array1, byte[] array2) {
        BitSet aSet = BitSet.valueOf(array1);
        aSet.xor(BitSet.valueOf(array2));
        return aSet.toByteArray();
    }

    public static void XORValues(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("parameters are not same length");
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = b[i] = (byte)(a[i] ^ b[i]);
        }
    }

    public static byte[] XORintoA(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("Parameters are not same length for xor.");
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = (byte)(a[i] ^ b[i]);
        }
        return a;
    }

    public static byte[] cleanXOR(byte[] a, byte[] b) {
        byte[] c = new byte[a.length];
        int i = 0;
        for (byte d : b) {
            c[i] = (byte)(d ^ a[i++]);
        }
        return c;
    }

    public static void arraycopy(byte[] source, int srcPos, byte[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = source[i + srcPos];
        }
    }

    public static void cls() {
        for (int i = 0; i < 100; ++i) {
            System.out.println();
        }
    }

    public static long longBMP(long a, long b, long c) {
        return BigInteger.valueOf(a).modPow(BigInteger.valueOf(b), BigInteger.valueOf(c)).longValue();
    }

    @SafeVarargs
    public static <T> T[] array(T ... array) {
        return array;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... list) {
        return Arrays.asList(list);
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... set) {
        return new HashSet<T>(Misc.list(set));
    }

    public static void print(Object o) {
        System.out.print(o);
    }

    public static void println(Object o) {
        System.out.println(o);
    }

    public static void require(boolean r) {
        if (!r) {
            throw new IllegalArgumentException();
        }
    }

    public static void require(boolean r, CharSequence message) {
        if (!r) {
            throw new IllegalArgumentException(message.toString());
        }
    }

    static {
        ISO8601ZULU.setTimeZone(TimeZone.getTimeZone("UTC"));
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

