/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.cache.refresh.ahead;

import blog.svenbayer.cache.refresh.ahead.condition.EnableCachingCondition;
import blog.svenbayer.cache.refresh.ahead.config.ReloadAheadProperties;
import blog.svenbayer.cache.refresh.ahead.exception.ReloadAheadException;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadKeyGenerator;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadService;
import blog.svenbayer.cache.refresh.ahead.task.AllCachesRefreshAheadScheduler;
import blog.svenbayer.cache.refresh.ahead.task.ReloadAheadCacheRefreshAheadScheduler;
import blog.svenbayer.cache.refresh.ahead.task.SelectiveCacheRefreshAheadScheduler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={ReloadAheadService.class})
@Conditional(value={EnableCachingCondition.class})
@EnableConfigurationProperties(value={ReloadAheadProperties.class})
@Configuration
public class CacheRefreshAheadConfiguration {
    @Bean
    public ReloadAheadKeyGenerator reloadAheadKeyGenerator() {
        return new ReloadAheadKeyGenerator();
    }

    @Bean
    public ReloadAheadCacheRefreshAheadScheduler reloadAheadCacheRefreshAheadScheduler(ReloadAheadProperties reloadAheadProperties, ReloadAheadService reloadAheadService) {
        if (reloadAheadProperties.getRefreshAheadInterval() != null) {
            return new AllCachesRefreshAheadScheduler(reloadAheadProperties, reloadAheadService);
        }
        if (reloadAheadProperties.getRefreshAheadIntervalCaches() != null) {
            return new SelectiveCacheRefreshAheadScheduler(reloadAheadProperties, reloadAheadService);
        }
        throw new ReloadAheadException("Please, specify the reload aheah interval in seconds as one of the following:\ncache.reload.ahead.refresh-ahead-interval-caches=5s\ncache.reload.ahead.refresh-ahead-interval-caches.longrun=5s");
    }
}

