/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.cache.refresh.ahead.redis.transformer;

import blog.svenbayer.cache.refresh.ahead.exception.ReloadAheadException;
import blog.svenbayer.cache.refresh.ahead.model.ReloadAheadKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Base64;

public class RedisKeyTransformerService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReloadAheadKey transformReloadAheadKey(byte[] key, String cacheName) {
        byte[] prefixBytes = (cacheName + "::").getBytes();
        byte[] keyWithoutPrefix = Arrays.copyOfRange(key, prefixBytes.length, key.length);
        byte[] decodedKey = Base64.getDecoder().decode(keyWithoutPrefix);
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decodedKey));){
            ReloadAheadKey reloadAheadKey = (ReloadAheadKey)ois.readObject();
            return reloadAheadKey;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new ReloadAheadException("Could not transform Redis key of cache '" + cacheName + "'!", ex);
        }
    }
}

