/*
 * Decompiled with CFR 0.152.
 */
package blue.contract;

import blue.contract.StepProcessor;
import blue.contract.WorkflowProcessor;
import blue.contract.debug.DebugContext;
import blue.contract.debug.DebugContextAware;
import blue.contract.exception.ContractProcessingException;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.model.event.FatalErrorEvent;
import blue.contract.utils.Events;
import blue.contract.utils.ExpressionEvaluator;
import blue.contract.utils.JSExecutor;
import blue.contract.utils.Workflows;
import blue.language.model.Node;
import blue.language.utils.UncheckedObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Optional;
import java.util.function.BiFunction;

public abstract class AbstractStepProcessor
implements StepProcessor,
DebugContextAware {
    protected Node step;
    protected final ExpressionEvaluator expressionEvaluator;
    protected DebugContext debugContext;

    public AbstractStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        this.step = step;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public Optional<WorkflowInstance> handleEvent(Node event, WorkflowProcessingContext context) {
        if (this.shouldExecuteStep(context)) {
            return this.executeHandleStep(event, context);
        }
        this.getDebugContext().skipWorkflowStep(WorkflowProcessor.ProcessingMode.HANDLE, this.getStepName().orElse("<StepWithNoName>"));
        return this.handleNextStepByOrder(event, context);
    }

    @Override
    public Optional<WorkflowInstance> finalizeEvent(Node event, WorkflowProcessingContext context) {
        if (this.shouldExecuteStep(context)) {
            return this.executeFinalizeStep(event, context);
        }
        this.getDebugContext().skipWorkflowStep(WorkflowProcessor.ProcessingMode.FINALIZE, this.getStepName().orElse("<StepWithNoName>"));
        return this.finalizeNextStepByOrder(event, context);
    }

    protected abstract Optional<WorkflowInstance> executeHandleStep(Node var1, WorkflowProcessingContext var2);

    protected abstract Optional<WorkflowInstance> executeFinalizeStep(Node var1, WorkflowProcessingContext var2);

    protected Optional<WorkflowInstance> handleNextStepByOrder(Node event, WorkflowProcessingContext context) {
        return this.processNextStep(event, context, (processor, ctx) -> processor.handleEvent(event, context));
    }

    protected Optional<WorkflowInstance> finalizeNextStepByOrder(Node event, WorkflowProcessingContext context) {
        return this.processNextStep(event, context, (processor, ctx) -> processor.finalizeEvent(event, context));
    }

    private Optional<WorkflowInstance> processNextStep(Node event, WorkflowProcessingContext context, BiFunction<StepProcessor, Node, Optional<WorkflowInstance>> stepFunction) {
        Optional<Node> nextStep;
        while ((nextStep = Workflows.getNextStepByOrder(this.step, context.getWorkflowInstance().getWorkflow())).isPresent()) {
            Optional<StepProcessor> stepProcessor = context.getStepProcessorProvider().getProcessor(nextStep.get());
            if (!stepProcessor.isPresent()) {
                throw new IllegalArgumentException("No StepProcessor found for event: " + UncheckedObjectMapper.JSON_MAPPER.disable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)event));
            }
            AbstractStepProcessor abstractStepProcessor = (AbstractStepProcessor)stepProcessor.get();
            if (abstractStepProcessor.shouldExecuteStep(context)) {
                abstractStepProcessor.setDebugContext(this.getDebugContext());
                return stepFunction.apply(abstractStepProcessor, event);
            }
            this.step = nextStep.get();
        }
        return this.completeWorkflow(context.getWorkflowInstance());
    }

    protected Optional<WorkflowInstance> completeWorkflow(WorkflowInstance workflowInstance) {
        workflowInstance.completed(true);
        return Optional.of(workflowInstance);
    }

    public Node getStep() {
        return this.step;
    }

    public Optional<String> getStepName() {
        return Optional.ofNullable(this.step.getName());
    }

    protected boolean shouldExecuteStep(WorkflowProcessingContext context) {
        String value;
        if (this.step.getProperties().containsKey("condition") && (value = (String)((Node)this.step.getProperties().get("condition")).getValue()) != null) {
            Node result = (Node)this.evaluateExpression(value, context);
            return result.getValue() == null || !(result.getValue() instanceof Boolean) || !Boolean.FALSE.equals(result.getValue());
        }
        return true;
    }

    protected Object evaluateExpression(Object potentialExpression, WorkflowProcessingContext context, ExpressionEvaluator.ExpressionScope scope, boolean resolveFinalLink) {
        if (potentialExpression instanceof String) {
            return this.expressionEvaluator.evaluate((String)potentialExpression, context, scope, resolveFinalLink);
        }
        return potentialExpression;
    }

    protected Object evaluateExpression(Object potentialExpression, WorkflowProcessingContext context, ExpressionEvaluator.ExpressionScope scope) {
        return this.evaluateExpression(potentialExpression, context, scope, true);
    }

    protected Object evaluateExpression(Object potentialExpression, WorkflowProcessingContext context) {
        return this.evaluateExpression(potentialExpression, context, ExpressionEvaluator.ExpressionScope.GLOBAL, true);
    }

    protected Object evaluateExpressionWithoutFinalLink(Object potentialExpression, WorkflowProcessingContext context) {
        return this.evaluateExpression(potentialExpression, context, ExpressionEvaluator.ExpressionScope.GLOBAL, false);
    }

    protected Node evaluateExpressionsRecursively(Node node, WorkflowProcessingContext context, ExpressionEvaluator.ExpressionScope scope, boolean resolveFinalLink) {
        return this.expressionEvaluator.processNodeRecursively(node, context, scope, resolveFinalLink);
    }

    protected Node evaluateExpressionsRecursively(Node node, WorkflowProcessingContext context, ExpressionEvaluator.ExpressionScope scope) {
        return this.evaluateExpressionsRecursively(node, context, scope, true);
    }

    protected Node evaluateExpressionsRecursively(Node node, WorkflowProcessingContext context) {
        return this.evaluateExpressionsRecursively(node, context, ExpressionEvaluator.ExpressionScope.GLOBAL, true);
    }

    protected Node evaluateExpressionsRecursivelyWithoutFinalLink(Node node, WorkflowProcessingContext context) {
        return this.evaluateExpressionsRecursively(node, context, ExpressionEvaluator.ExpressionScope.GLOBAL, false);
    }

    protected Optional<WorkflowInstance> processJSException(JSExecutor.JSException ex, WorkflowProcessingContext context) {
        ContractProcessingContext contractProcessingContext = context.getContractProcessingContext();
        if (ex instanceof JSExecutor.RejectAndAwaitNextEventException) {
            context.rollbackTransaction();
            return Optional.empty();
        }
        if (ex instanceof JSExecutor.TerminateContractWithErrorException) {
            this.terminateContractWithError(ex, context, contractProcessingContext);
            return Optional.empty();
        }
        if (ex instanceof JSExecutor.JSCriticalException) {
            this.terminateContractWithError(ex, context, contractProcessingContext);
            return Optional.empty();
        }
        this.terminateContractWithError(ex, context, contractProcessingContext);
        return Optional.empty();
    }

    private void terminateContractWithError(JSExecutor.JSException ex, WorkflowProcessingContext workflowProcessingContext, ContractProcessingContext contractProcessingContext) {
        contractProcessingContext.terminatedWithError(true);
        if (!contractProcessingContext.getContractInstances().isEmpty()) {
            contractProcessingContext.getCurrentContractInstance().getProcessingState().terminatedWithError(true);
            contractProcessingContext.getRootContractInstance().getProcessingState().terminatedWithError(true);
        }
        FatalErrorEvent errorEvent = new FatalErrorEvent().errorMessage("Critical, irrecoverable JS error, contract terminated with error.").stackTrace(((JSExecutor.JSCriticalException)ex).getJsStackTrace());
        Node errorEventNode = contractProcessingContext.getBlue().objectToNode((Object)errorEvent);
        ContractProcessingEvent processingEvent = Events.prepareContractProcessingEvent(errorEventNode, this.step.getName(), workflowProcessingContext);
        Node processingEventNode = contractProcessingContext.getBlue().objectToNode((Object)processingEvent);
        workflowProcessingContext.getContractProcessingContext().getEmittedEvents().add(processingEventNode);
        throw new ContractProcessingException("Critical JS error", ex);
    }

    @Override
    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    @Override
    public void setDebugContext(DebugContext debugContext) {
        this.debugContext = debugContext;
    }
}

