/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.model;

import blue.contract.StepProcessorProvider;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractProcessorConfig;
import blue.contract.model.LocalContract;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.BlueIds;
import blue.language.utils.NodePathAccessor;
import blue.language.utils.NodeToMapListOrValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ContractProcessingContext {
    private Node contract;
    private int contractInstanceId;
    private List<Node> emittedEvents = new ArrayList<Node>();
    private List<ContractInstance> contractInstances;
    private int startedLocalContracts;
    private String initiateContractEntryBlueId;
    private String initiateContractProcessingEntryBlueId;
    private boolean completed;
    private boolean terminatedWithError;
    private StepProcessorProvider stepProcessorProvider;
    private Blue blue;
    private ContractProcessorConfig config;
    private Node incomingEvent;

    public Node getContract() {
        return this.contract;
    }

    public int getContractInstanceId() {
        return this.contractInstanceId;
    }

    public List<Node> getEmittedEvents() {
        return this.emittedEvents;
    }

    public List<ContractInstance> getContractInstances() {
        return this.contractInstances;
    }

    public int getStartedLocalContracts() {
        return this.startedLocalContracts;
    }

    public String getInitiateContractEntryBlueId() {
        return this.initiateContractEntryBlueId;
    }

    public String getInitiateContractProcessingEntryBlueId() {
        return this.initiateContractProcessingEntryBlueId;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isTerminatedWithError() {
        return this.terminatedWithError;
    }

    public StepProcessorProvider getStepProcessorProvider() {
        return this.stepProcessorProvider;
    }

    public Blue getBlue() {
        return this.blue;
    }

    public Node getIncomingEvent() {
        return this.incomingEvent;
    }

    public ContractProcessorConfig getConfig() {
        return this.config;
    }

    public ContractProcessingContext contract(Node contract) {
        this.contract = contract;
        return this;
    }

    public ContractProcessingContext contractInstanceId(int contractInstanceId) {
        this.contractInstanceId = contractInstanceId;
        return this;
    }

    public ContractProcessingContext emittedEvents(List<Node> emittedEvents) {
        this.emittedEvents = emittedEvents;
        return this;
    }

    public ContractProcessingContext startedLocalContracts(int startedLocalContracts) {
        this.startedLocalContracts = startedLocalContracts;
        return this;
    }

    public ContractProcessingContext contractInstances(List<ContractInstance> contractInstances) {
        this.contractInstances = contractInstances;
        return this;
    }

    public ContractProcessingContext initiateContractEntryBlueId(String initiateContractEntryBlueId) {
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
        return this;
    }

    public ContractProcessingContext initiateContractProcessingEntryBlueId(String initiateContractProcessingEntryBlueId) {
        this.initiateContractProcessingEntryBlueId = initiateContractProcessingEntryBlueId;
        return this;
    }

    public ContractProcessingContext completed(boolean completed) {
        this.completed = completed;
        return this;
    }

    public ContractProcessingContext terminatedWithError(boolean terminatedWithError) {
        this.terminatedWithError = terminatedWithError;
        return this;
    }

    public ContractProcessingContext stepProcessorProvider(StepProcessorProvider stepProcessorProvider) {
        this.stepProcessorProvider = stepProcessorProvider;
        return this;
    }

    public ContractProcessingContext blue(Blue blue) {
        this.blue = blue;
        return this;
    }

    public ContractProcessingContext config(ContractProcessorConfig config) {
        this.config = config;
        return this;
    }

    public ContractProcessingContext incomingEvent(Node incomingEvent) {
        this.incomingEvent = incomingEvent;
        return this;
    }

    public Object accessContract(String path, boolean useGlobalScope, boolean resolveFinalLink) {
        Object result;
        Function<Node, Node> linkingProvider = useGlobalScope ? this::linkingProviderImplementation : null;
        try {
            result = NodePathAccessor.get((Node)this.blue.objectToNode((Object)this.contract), (String)path, linkingProvider, (boolean)resolveFinalLink);
        }
        catch (IllegalArgumentException ex) {
            result = null;
        }
        if (result instanceof Node) {
            result = NodeToMapListOrValue.get((Node)((Node)result), (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE);
        } else if (result instanceof BigInteger) {
            BigInteger bigInt = (BigInteger)result;
            return this.isInJavaScriptSafeRange(bigInt) ? Long.valueOf(bigInt.longValue()) : bigInt;
        }
        return result;
    }

    private Node linkingProviderImplementation(Node node) {
        String localContractBlueId;
        if (node.getType() != null && (localContractBlueId = (String)BlueIds.getBlueId(LocalContract.class).orElseThrow(() -> new IllegalStateException("LocalContract class must have @BlueId annotation properly set."))).equals(node.getType().get("/blueId"))) {
            BigInteger id = (BigInteger)((Node)node.getProperties().get("id")).getValue();
            return this.contractInstances.stream().filter(instance -> instance.getId() == id.intValue()).findFirst().map(ContractInstance::getContractState).orElse(null);
        }
        return null;
    }

    private boolean isInJavaScriptSafeRange(BigInteger number) {
        BigInteger min = new BigInteger("-9007199254740991");
        BigInteger max = new BigInteger("9007199254740991");
        return number.compareTo(min) >= 0 && number.compareTo(max) <= 0;
    }

    public ContractInstance getContractInstance(int instanceId) {
        return this.contractInstances.stream().filter(instance -> instance.getId() == instanceId).findFirst().orElseThrow(() -> new IllegalStateException("No contract instance with id=" + instanceId + " found"));
    }

    public void replaceContractInstance(int instanceId, ContractInstance contractInstance) {
        if (this.contractInstances == null) {
            throw new IllegalStateException("Contract instances list is not initialized");
        }
        int index = -1;
        for (int i = 0; i < this.contractInstances.size(); ++i) {
            if (this.contractInstances.get(i).getId() != instanceId) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("No contract instance with id=" + instanceId + " found");
        }
        this.contractInstances.set(index, contractInstance);
    }

    public ContractInstance getCurrentContractInstance() {
        return this.getContractInstance(this.getContractInstanceId());
    }

    public ContractInstance getRootContractInstance() {
        return this.getContractInstance(0);
    }
}

