/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.model;

import blue.contract.StepProcessorProvider;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingTransaction;
import blue.language.Blue;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WorkflowProcessingContext {
    private WorkflowInstance workflowInstance;
    private ContractProcessingContext contractProcessingContext;
    private StepProcessorProvider stepProcessorProvider;
    private WorkflowProcessingTransaction transaction;
    private Blue blue;

    public WorkflowProcessingContext() {
    }

    public WorkflowProcessingContext(WorkflowInstance workflowInstance, ContractProcessingContext contractProcessingContext, StepProcessorProvider stepProcessorProvider) {
        this.workflowInstance = workflowInstance;
        this.contractProcessingContext = contractProcessingContext;
        this.stepProcessorProvider = stepProcessorProvider;
        this.blue = contractProcessingContext.getBlue();
    }

    public WorkflowInstance getWorkflowInstance() {
        return this.workflowInstance;
    }

    public ContractProcessingContext getContractProcessingContext() {
        return this.contractProcessingContext;
    }

    public StepProcessorProvider getStepProcessorProvider() {
        return this.stepProcessorProvider;
    }

    public void beginTransaction() {
        this.transaction = new WorkflowProcessingTransaction().contract((Node)this.blue.clone((Object)this.contractProcessingContext.getContract())).emittedEvents(new ArrayList<Node>(this.contractProcessingContext.getEmittedEvents())).contractInstances(this.contractProcessingContext.getContractInstances().stream().map(instance -> (ContractInstance)this.blue.clone(instance)).collect(Collectors.toList())).startedLocalContracts(this.contractProcessingContext.getStartedLocalContracts()).contractCompleted(this.contractProcessingContext.isCompleted()).terminatedWithError(this.contractProcessingContext.isTerminatedWithError()).workflowCurrentStepName(this.workflowInstance.getCurrentStepName()).workflowStepResults((Map<String, Object>)(this.workflowInstance.getStepResults() == null ? null : new HashMap<String, Object>(this.workflowInstance.getStepResults()))).workflowCompleted(this.workflowInstance.isCompleted()).workflowNestedWorkflowInstance(this.workflowInstance.getNestedWorkflowInstance() != null ? (WorkflowInstance)this.blue.clone((Object)this.workflowInstance.getNestedWorkflowInstance()) : null);
    }

    public void commitTransaction() {
        this.transaction = null;
    }

    public void rollbackTransaction() {
        if (this.transaction != null) {
            this.contractProcessingContext.contract(this.transaction.getContract());
            this.contractProcessingContext.emittedEvents(this.transaction.getEmittedEvents());
            this.contractProcessingContext.contractInstances(this.transaction.getContractInstances());
            this.contractProcessingContext.startedLocalContracts(this.transaction.getStartedLocalContracts());
            this.contractProcessingContext.completed(this.transaction.isContractCompleted());
            this.contractProcessingContext.terminatedWithError(this.transaction.isTerminatedWithError());
            this.workflowInstance.currentStepName(this.transaction.getWorkflowCurrentStepName());
            this.workflowInstance.stepResults(this.transaction.getWorkflowStepResults());
            this.workflowInstance.completed(this.transaction.isWorkflowCompleted());
            this.workflowInstance.nestedWorkflowInstance(this.transaction.getWorkflowNestedWorkflowInstance());
            this.transaction = null;
        }
    }

    public WorkflowProcessingContext workflowInstance(WorkflowInstance workflowInstance) {
        this.workflowInstance = workflowInstance;
        return this;
    }

    public WorkflowProcessingContext contractProcessingContext(ContractProcessingContext contractProcessingContext) {
        this.contractProcessingContext = contractProcessingContext;
        return this;
    }

    public WorkflowProcessingContext stepProcessorProvider(StepProcessorProvider stepProcessorProvider) {
        this.stepProcessorProvider = stepProcessorProvider;
        return this;
    }
}

