/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager;

import blue.contract.packager.model.BluePackage;
import blue.contract.packager.model.DependencyGraph;
import blue.contract.packager.model.DirectoryNode;
import blue.contract.packager.utils.BluePackageInitializer;
import blue.contract.packager.utils.NodePreprocessor;
import blue.contract.packager.utils.PackageMappingsUpdater;
import blue.contract.packager.utils.TopologicalSorter;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DependencyProcessor {
    private final DependencyGraph graph;
    private final Map<String, BluePackage> processedPackages;
    private final TopologicalSorter topologicalSorter;
    private final NodePreprocessor nodePreprocessor;
    private final BluePackageInitializer bluePackageInitializer;
    private final PackageMappingsUpdater packageMappingsUpdater;

    public DependencyProcessor(DependencyGraph graph) {
        this.graph = graph;
        this.processedPackages = new HashMap<String, BluePackage>();
        this.topologicalSorter = new TopologicalSorter();
        this.nodePreprocessor = new NodePreprocessor();
        this.bluePackageInitializer = new BluePackageInitializer();
        this.packageMappingsUpdater = new PackageMappingsUpdater();
    }

    public List<BluePackage> process() {
        List<String> processingOrder = this.graph.getProcessingOrder();
        for (String dirName : processingOrder) {
            this.processDirectory(dirName);
        }
        return new ArrayList<BluePackage>(this.processedPackages.values());
    }

    private void processDirectory(String dirName) {
        List<String> processingOrder;
        DirectoryNode dir = this.graph.getDirectories().get(dirName);
        BluePackage bluePackage = this.bluePackageInitializer.initialize(dirName, dir.getDependency(), this.processedPackages);
        this.processedPackages.put(dirName, bluePackage);
        HashMap<String, Node> nodes = new HashMap<String, Node>(dir.getNodes());
        HashSet<String> processed = new HashSet<String>();
        try {
            processingOrder = this.topologicalSorter.sort(nodes);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Cyclic dependency detected in directory '" + dirName + "': " + e.getMessage());
        }
        for (String nodeName : processingOrder) {
            this.processNode(nodeName, nodes, processed, dirName);
        }
    }

    private void processNode(String nodeName, Map<String, Node> nodes, Set<String> processed, String dirName) {
        if (processed.contains(nodeName)) {
            return;
        }
        Node node = nodes.values().stream().filter(n -> n.getName().equals(nodeName)).findFirst().orElseThrow();
        Node preprocessedNode = this.nodePreprocessor.preprocess(node, dirName, this.processedPackages);
        nodes.put(nodeName, preprocessedNode);
        BluePackage bluePackage = this.processedPackages.get(dirName);
        bluePackage.addPreprocessedNode(nodeName, preprocessedNode);
        this.packageMappingsUpdater.update(dirName, nodeName, preprocessedNode, this.processedPackages);
        processed.add(nodeName);
    }
}

