/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager.graphbuilder;

import blue.contract.packager.graphbuilder.DependencyGraphBuilder;
import blue.contract.packager.model.DependencyGraph;
import blue.language.model.Node;
import blue.language.utils.UncheckedObjectMapper;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileSystemDependencyGraphBuilder
implements DependencyGraphBuilder {
    private final Path rootPath;

    public FileSystemDependencyGraphBuilder(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public DependencyGraph buildDependencyGraph(String rootDir) throws IOException {
        DependencyGraph graph = new DependencyGraph();
        Path fullPath = this.rootPath.resolve(rootDir);
        if (!Files.exists(fullPath, new LinkOption[0])) {
            throw new IOException("Root directory not found: " + fullPath);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(fullPath);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                String dirName = path.getFileName().toString();
                String dependency = this.readDependency(path.resolve("_extends.txt"));
                graph.addDirectory(dirName, dependency);
                this.processFiles(path, dirName, graph);
            }
        }
        return graph;
    }

    private String readDependency(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("Dependency file not found: " + path);
        }
        String content = Files.readString(path).trim();
        if (content.isEmpty() || content.lines().count() != 1L) {
            throw new IOException("Invalid dependency file format. Expected one line in: " + path);
        }
        return content;
    }

    private void processFiles(Path dirPath, String dirName, DependencyGraph graph) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath, "*.blue");){
            for (Path file : stream) {
                Node contract = (Node)UncheckedObjectMapper.YAML_MAPPER.readValue(Files.readString(file), Node.class);
                graph.addNode(dirName, contract);
            }
        }
    }
}

