/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager.utils;

import blue.contract.packager.utils.NodeDependencyAnalyzer;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopologicalSorter {
    private final NodeDependencyAnalyzer dependencyAnalyzer = new NodeDependencyAnalyzer();

    public List<String> sort(Map<String, Node> nodes) {
        Map<String, Set<String>> graph = this.dependencyAnalyzer.analyzeDependencies(nodes);
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> temp = new HashSet<String>();
        ArrayList<String> path = new ArrayList<String>();
        for (String node : nodes.keySet()) {
            if (visited.contains(node)) continue;
            this.dfs(node, graph, visited, temp, result, path);
        }
        return result;
    }

    private void dfs(String node, Map<String, Set<String>> graph, Set<String> visited, Set<String> temp, List<String> result, List<String> path) {
        if (temp.contains(node)) {
            int startIndex = path.indexOf(node);
            List<String> cycle = path.subList(startIndex, path.size());
            cycle.add(node);
            throw new IllegalStateException("Cyclic dependency detected: " + String.join((CharSequence)" -> ", cycle));
        }
        if (!visited.contains(node)) {
            temp.add(node);
            path.add(node);
            Set dependencies = graph.getOrDefault(node, Collections.emptySet());
            for (String dep : dependencies) {
                this.dfs(dep, graph, visited, temp, result, path);
            }
            visited.add(node);
            temp.remove(node);
            path.remove(path.size() - 1);
            result.add(node);
        }
    }
}

