/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.debug.DebugUtils;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.ExternalContract;
import blue.contract.model.LocalContract;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.utils.ExpressionEvaluator;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.limits.Limits;
import blue.language.utils.limits.PathLimits;
import java.util.Map;
import java.util.Optional;

public class ExpectEventStepProcessor
extends AbstractStepProcessor {
    public ExpectEventStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        super(step, expressionEvaluator);
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        Blue blue = context.getContractProcessingContext().getBlue();
        Node expectedEventNode = this.extractExpectedEvent(context, blue);
        Object contract = this.extractContract(context, blue);
        Optional eventClass = blue.determineClass(event);
        if (eventClass.isPresent()) {
            if (ContractProcessingEvent.class.equals(eventClass.get())) {
                ContractProcessingEvent contractProcessingEvent = (ContractProcessingEvent)blue.nodeToObject(event, ContractProcessingEvent.class);
                if (!this.matchesContract(contractProcessingEvent, contract, context)) {
                    this.getDebugContext().addWorkflowStepResult(this.getStepName(), Map.of("contractProcessingEventMatch", Boolean.FALSE, "details", DebugUtils.contractProcessingEventMatchingDetails(contractProcessingEvent, contract, context)));
                    return Optional.empty();
                }
                event = contractProcessingEvent.getEvent();
                context.getContractProcessingContext().incomingEvent(event);
            } else if (contract != null) {
                this.getDebugContext().addWorkflowStepResult(this.getStepName(), Map.of("contractProcessingEventMatch", Boolean.FALSE, "reason", "contract is provided, but event is not ContractProcessingEvent", "eventClass", ((Class)eventClass.get()).getSimpleName()));
                return Optional.empty();
            }
        } else if (contract != null) {
            this.getDebugContext().addWorkflowStepResult(this.getStepName(), Map.of("contractProcessingEventMatch", Boolean.FALSE, "reason", "contract is provided, but event class can't be determined"));
            return Optional.empty();
        }
        ContractProcessingContext contractContext = context.getContractProcessingContext();
        boolean nodeMatchesType = contractContext.getBlue().nodeMatchesType(event, expectedEventNode);
        if (nodeMatchesType) {
            Optional<String> stepName = this.getStepName();
            if (stepName.isPresent()) {
                context.getWorkflowInstance().addStepResult(stepName.get(), event);
            }
            this.getDebugContext().addWorkflowStepResult(stepName, Map.of("nodeMatchesType", Boolean.TRUE));
            return this.finalizeNextStepByOrder(event, context);
        }
        this.getDebugContext().addWorkflowStepResult(this.getStepName(), Map.of("nodeMatchesType", Boolean.FALSE, "nodes", DebugUtils.nodeMatchingDetails(contractContext.getBlue(), event, expectedEventNode)));
        return Optional.empty();
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext workflowProcessingContext) {
        WorkflowInstance workflowInstance = workflowProcessingContext.getWorkflowInstance();
        workflowInstance.currentStepName(this.step.getName());
        return Optional.of(workflowInstance);
    }

    private boolean matchesContractDetails(ContractProcessingEvent contractProcessingEvent, Integer contractInstanceId, String initiateContractEntryBlueId) {
        return (contractInstanceId == null || contractInstanceId.equals(contractProcessingEvent.getContractInstanceId())) && initiateContractEntryBlueId.equals(contractProcessingEvent.getInitiateContractEntry().get("/blueId"));
    }

    public Node extractExpectedEvent(WorkflowProcessingContext context, Blue blue) {
        Node expectedEventNode = (Node)this.step.getProperties().get("event");
        if (expectedEventNode == null) {
            throw new IllegalArgumentException("No \"event\" defined for step with name \"" + this.getStepName().orElse("<noname>") + "\" in workflow with name \"" + context.getWorkflowInstance().getWorkflow().getName() + "\".");
        }
        blue.extend(expectedEventNode, (Limits)PathLimits.withSinglePath((String)"/"));
        expectedEventNode = this.evaluateExpressionsRecursively(expectedEventNode, context);
        return expectedEventNode;
    }

    private Object extractContract(WorkflowProcessingContext context, Blue blue) {
        Node contractNode = (Node)this.step.getProperties().get("contract");
        if (contractNode != null) {
            if (contractNode.getValue() != null) {
                Object contractObj = this.evaluateExpressionWithoutFinalLink(contractNode.getValue(), context);
                contractNode = blue.objectToNode(contractObj);
            } else {
                contractNode = this.evaluateExpressionsRecursively(contractNode, context);
            }
            blue.extend(contractNode, (Limits)PathLimits.withSinglePath((String)"/"));
            Optional nodeClass = blue.determineClass(contractNode);
            if (!nodeClass.isPresent() || !((Class)nodeClass.get()).equals(LocalContract.class) && !((Class)nodeClass.get()).equals(ExternalContract.class)) {
                throw new IllegalArgumentException("Property \"contract\" must be either a \"Local Contract\" or \"External Contract\".");
            }
            return blue.nodeToObject(contractNode, (Class)nodeClass.get());
        }
        return null;
    }

    private boolean matchesContract(ContractProcessingEvent contractProcessingEvent, Object contract, WorkflowProcessingContext context) {
        ContractProcessingContext contractProcessingContext = context.getContractProcessingContext();
        int currentContractInstanceId = contractProcessingContext.getContractInstanceId();
        String currentInitiateContractEntryBlueId = contractProcessingContext.getInitiateContractEntryBlueId();
        if (contract == null) {
            return this.matchesContractDetails(contractProcessingEvent, currentContractInstanceId, currentInitiateContractEntryBlueId);
        }
        if (contract instanceof LocalContract) {
            LocalContract localContract = (LocalContract)contract;
            return this.matchesContractDetails(contractProcessingEvent, localContract.getId(), currentInitiateContractEntryBlueId);
        }
        if (contract instanceof ExternalContract) {
            ExternalContract externalContract = (ExternalContract)contract;
            return this.matchesContractDetails(contractProcessingEvent, externalContract.getLocalContractInstanceId(), externalContract.getInitiateContractEntry());
        }
        return false;
    }
}

