/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.model.AssistantTask;
import blue.contract.model.AssistantTaskReadyEvent;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.TimelineEntry;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.simulator.AssistantProcessor;
import blue.contract.simulator.Simulator;
import blue.language.Blue;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Assistant {
    private final Blue blue;
    private final String initiateContractEntryBlueId;
    private String assistantTimeline;
    private Simulator simulator;
    private Map<ProcessorKey, AssistantProcessor<?, ?>> processors = new HashMap();

    public Assistant(Blue blue, String initiateContractEntryBlueId) {
        this.blue = blue;
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
        System.out.println("Assistant created with initiateContractEntryBlueId: " + initiateContractEntryBlueId);
    }

    public Assistant(Blue blue, String initiateContractEntryBlueId, String assistantTimeline) {
        this(blue, initiateContractEntryBlueId);
        this.assistantTimeline = assistantTimeline;
    }

    public void start(String assistantTimeline, String runnerTimeline, Simulator simulator) {
        this.assistantTimeline = assistantTimeline;
        this.simulator = simulator;
        System.out.println("Assistant started. Subscribing to ContractUpdateActions on runnerTimeline: " + runnerTimeline);
        simulator.subscribe(entry -> runnerTimeline.equals(entry.getTimeline()) && entry.getMessage() instanceof ContractUpdateAction, this::processContractUpdateAction);
    }

    public <Req, Res> void registerProcessor(Class<Req> requestClass, Class<Res> responseClass, AssistantProcessor<Req, Res> processor) {
        ProcessorKey key = new ProcessorKey(requestClass, responseClass);
        this.processors.put(key, processor);
        System.out.println("Registered processor for request type " + requestClass.getSimpleName() + " and response type " + responseClass.getSimpleName());
    }

    public <Req, Res> List<AssistantTask<Req, Res>> processContractUpdateAction(TimelineEntry<Object> entry) {
        System.out.println("Processing ContractUpdateAction");
        ContractUpdateAction action = (ContractUpdateAction)entry.getMessage();
        ArrayList<AssistantTask<Req, Res>> results = new ArrayList<AssistantTask<Req, Res>>();
        if (action.getEmittedEvents() != null) {
            for (Node eventNode : action.getEmittedEvents()) {
                ContractProcessingEvent contractProcessingEvent;
                AssistantTask<Req, Res> task;
                Optional eventClass = this.blue.determineClass(eventNode);
                if (!eventClass.isPresent() || !ContractProcessingEvent.class.equals(eventClass.get()) || (task = this.processContractProcessingEvent(contractProcessingEvent = (ContractProcessingEvent)this.blue.nodeToObject(eventNode, ContractProcessingEvent.class))) == null) continue;
                results.add(task);
            }
        }
        return results;
    }

    private <Req, Res> AssistantTask<Req, Res> processContractProcessingEvent(ContractProcessingEvent contractProcessingEvent) {
        Node actualEventNode = contractProcessingEvent.getEvent();
        if (actualEventNode != null) {
            Optional actualEventClass = this.blue.determineClass(actualEventNode);
            if (actualEventClass.isPresent() && AssistantTaskReadyEvent.class.equals(actualEventClass.get())) {
                AssistantTaskReadyEvent assistantTaskReadyEvent = (AssistantTaskReadyEvent)this.blue.nodeToObject(actualEventNode, AssistantTaskReadyEvent.class);
                return this.processAssistantTaskReadyEvent(assistantTaskReadyEvent);
            }
            System.out.println("Event is not an AssistantTaskReadyEvent: " + actualEventClass.orElse(null));
            return null;
        }
        System.out.println("ContractProcessingEvent contains no event");
        return null;
    }

    private <Req, Res> AssistantTask<Req, Res> processAssistantTaskReadyEvent(AssistantTaskReadyEvent event) {
        System.out.println("Processing AssistantTaskReadyEvent");
        if (event.getTask() != null) {
            return this.processStep(this.blue.objectToNode((Object)event.getTask()));
        }
        System.out.println("Warning: AssistantTaskReadyEvent contains no AssistantTask");
        return null;
    }

    private <Req, Res> AssistantTask<Req, Res> processStep(Node step) {
        System.out.println("Processing step: " + step.getDescription());
        AssistantTask task = (AssistantTask)this.blue.nodeToObject(step, AssistantTask.class);
        Class<?> requestClass = task.getRequest().getClass();
        Class<?> responseClass = task.getResponse().getClass();
        System.out.println("Looking for processor for request type " + requestClass.getSimpleName() + " and response type " + responseClass.getSimpleName());
        ProcessorKey key = new ProcessorKey(requestClass, responseClass);
        AssistantProcessor<?, ?> processor = this.processors.get(key);
        if (processor != null) {
            System.out.println("Processor found. Processing request...");
            Object response = processor.process(task.getRequest(), this.blue);
            AssistantTask result = (AssistantTask)this.blue.clone((Object)task);
            result.response(response);
            if (this.simulator != null) {
                System.out.println("Appending processed result to timeline:");
                System.out.println(this.blue.objectToSimpleYaml((Object)result));
                this.simulator.appendEntry(this.assistantTimeline, this.initiateContractEntryBlueId, this.blue.objectToNode((Object)result));
            }
            return result;
        }
        System.out.println("Error: No processor found for the given request and response types");
        throw new RuntimeException("No processor found for request type " + requestClass.getSimpleName() + (String)(responseClass != null ? " and response type " + responseClass.getSimpleName() : ""));
    }

    private static class ProcessorKey {
        private final Class<?> requestClass;
        private final Class<?> responseClass;

        public ProcessorKey(Class<?> requestClass, Class<?> responseClass) {
            this.requestClass = requestClass;
            this.responseClass = responseClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorKey that = (ProcessorKey)o;
            return this.requestClass.equals(that.requestClass) && this.responseClass.equals(that.responseClass);
        }

        public int hashCode() {
            return 31 * this.requestClass.hashCode() + this.responseClass.hashCode();
        }
    }
}

