/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.model.AssistantTask;
import blue.contract.model.AssistantTaskReadyEvent;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.blink.SimulatorTimelineEntry;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.simulator.AssistantProcessor;
import blue.contract.simulator.SimulatorMT;
import blue.language.Blue;
import blue.language.model.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AssistantMT {
    private final Blue blue;
    private final String initiateContractEntryBlueId;
    private String assistantTimeline;
    private SimulatorMT simulator;
    private Map<ProcessorKey, AssistantProcessor<?, ?>> processors = new HashMap();
    private volatile boolean isRunning = true;

    public AssistantMT(Blue blue, String initiateContractEntryBlueId) {
        this.blue = blue;
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
    }

    public void start(String assistantTimeline, String runnerTimeline, SimulatorMT simulator) {
        this.assistantTimeline = assistantTimeline;
        this.simulator = simulator;
        simulator.subscribe(entry -> {
            System.out.println("Assistant is checking condition");
            boolean result = runnerTimeline.equals(entry.getTimeline()) && entry.getMessage() instanceof ContractUpdateAction;
            System.out.println("RunnerTimeline: " + runnerTimeline);
            System.out.println("Entry timeline: " + entry.getTimeline());
            System.out.println("Entry message: " + entry.getMessage().getClass());
            System.out.println("Result is " + result);
            return result;
        }, this::processContractUpdateAction);
    }

    public <Req, Res> void registerProcessor(Class<Req> requestClass, Class<Res> responseClass, AssistantProcessor<Req, Res> processor) {
        ProcessorKey key = new ProcessorKey(requestClass, responseClass);
        this.processors.put(key, processor);
    }

    private void processContractUpdateAction(SimulatorTimelineEntry<Object> entry) {
        System.out.println(this.isRunning);
        if (!this.isRunning) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            System.out.println("got action");
            System.out.println(this.blue.nodeToSimpleYaml(this.blue.objectToNode(entry.getMessage())));
            ContractUpdateAction action = (ContractUpdateAction)entry.getMessage();
            if (action.getEmittedEvents() != null) {
                System.out.println("got emitted events");
                for (Node eventNode : action.getEmittedEvents()) {
                    Optional eventClass = this.blue.determineClass(eventNode);
                    if (!eventClass.isPresent() || !ContractProcessingEvent.class.equals(eventClass.get())) continue;
                    ContractProcessingEvent contractProcessingEvent = (ContractProcessingEvent)this.blue.nodeToObject(eventNode, ContractProcessingEvent.class);
                    this.processContractProcessingEvent(contractProcessingEvent);
                }
            }
        });
    }

    private void processContractProcessingEvent(ContractProcessingEvent contractProcessingEvent) {
        Node actualEventNode = contractProcessingEvent.getEvent();
        if (actualEventNode != null) {
            Optional actualEventClass = this.blue.determineClass(actualEventNode);
            if (actualEventClass.isPresent() && AssistantTaskReadyEvent.class.equals(actualEventClass.get())) {
                AssistantTaskReadyEvent assistantTaskReadyEvent = (AssistantTaskReadyEvent)this.blue.nodeToObject(actualEventNode, AssistantTaskReadyEvent.class);
                this.processAssistantTaskReadyEvent(assistantTaskReadyEvent);
            } else {
                System.out.println("Event is not an AssistantTaskReadyEvent: " + actualEventClass.orElse(null));
            }
        }
    }

    private void processAssistantTaskReadyEvent(AssistantTaskReadyEvent event) {
        if (event.getTask() != null) {
            this.processStep(this.blue.objectToNode((Object)event.getTask()));
        }
    }

    private <Req, Res> void processStep(Node step) {
        System.out.println("Assistant is processing: ");
        System.out.println(this.blue.nodeToSimpleYaml(step));
        AssistantTask task = (AssistantTask)this.blue.nodeToObject(step, AssistantTask.class);
        Class<?> requestClass = task.getRequest().getClass();
        Class<?> responseClass = task.getResponse().getClass();
        System.out.println("Looking for processor for request type " + requestClass.getSimpleName() + " and response type " + responseClass.getSimpleName());
        ProcessorKey key = new ProcessorKey(requestClass, responseClass);
        AssistantProcessor<?, ?> processor = this.processors.get(key);
        if (processor == null) {
            throw new RuntimeException("No processor found for request type " + requestClass.getSimpleName() + (String)(responseClass != null ? " and response type " + responseClass.getSimpleName() : ""));
        }
        System.out.println("Processor found. Processing request...");
        Object response = processor.process(task.getRequest(), this.blue);
        AssistantTask result = (AssistantTask)this.blue.clone((Object)task);
        result.response(response);
        System.out.println("Appending processed result to timeline:");
        System.out.println(this.blue.objectToSimpleYaml((Object)result));
        this.simulator.appendEntry(this.assistantTimeline, this.initiateContractEntryBlueId, result);
    }

    public void stop() {
        this.isRunning = false;
        System.out.println("AssistantMT stopped");
    }

    private static class ProcessorKey {
        private final Class<?> requestClass;
        private final Class<?> responseClass;

        public ProcessorKey(Class<?> requestClass, Class<?> responseClass) {
            this.requestClass = requestClass;
            this.responseClass = responseClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorKey that = (ProcessorKey)o;
            return this.requestClass.equals(that.requestClass) && this.responseClass.equals(that.responseClass);
        }

        public int hashCode() {
            return 31 * this.requestClass.hashCode() + this.responseClass.hashCode();
        }
    }
}

