/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.SingleEventContractProcessor;
import blue.contract.model.Contract;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.blink.SimulatorTimelineEntry;
import blue.contract.processor.StandardProcessorsProvider;
import blue.contract.simulator.Simulator;
import blue.contract.simulator.utils.ContractRunnerSubscriptionUtils;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.BlueIds;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import blue.language.utils.limits.Limits;
import blue.language.utils.limits.TypeSpecificPropertyFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class ContractRunner {
    private final Blue blue;
    private final SingleEventContractProcessor singleEventContractProcessor;
    private final String initiateContractEntryBlueId;
    private final String initiateContractProcessingEntryBlueId;
    private final List<Node> pendingEvents;
    private ContractInstance currentInstance;
    private List<Node> processedEvents = new ArrayList<Node>();
    private List<ContractUpdateAction> contractUpdateActions = new ArrayList<ContractUpdateAction>();
    private Simulator simulator;

    public ContractRunner(Blue blue, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        StandardProcessorsProvider provider = new StandardProcessorsProvider(blue);
        this.blue = blue;
        blue.setGlobalLimits((Limits)new TypeSpecificPropertyFilter((String)BlueIds.getBlueId(SimulatorTimelineEntry.class).orElseThrow(() -> new RuntimeException("No Simulator Timeline Entry blueId found.")), (Set)ImmutableSet.of((Object)"timeline", (Object)"timelinePrev", (Object)"thread", (Object)"threadPrev", (Object)"signature")));
        this.singleEventContractProcessor = new SingleEventContractProcessor(provider, blue);
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
        this.initiateContractProcessingEntryBlueId = initiateContractProcessingEntryBlueId;
        this.pendingEvents = new ArrayList<Node>();
    }

    public ContractUpdateAction initiateContract(Object contract) {
        return this.initiateContract(this.blue.objectToNode(contract));
    }

    public ContractUpdateAction initiateContract(Node contract) {
        ContractUpdateAction update = this.singleEventContractProcessor.initiate(contract, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId);
        this.contractUpdateActions.add(update);
        this.currentInstance = update.getContractInstance();
        if (update.getEmittedEvents() != null) {
            this.pendingEvents.addAll(update.getEmittedEvents());
        }
        return update;
    }

    public void addEvent(Node event) {
        this.pendingEvents.add(event);
    }

    public void addEvent(Object event) {
        this.addEvent(this.blue.objectToNode(this.blue.clone(event)));
    }

    public void processEvents() {
        this.processEvents(this.pendingEvents.size());
    }

    public void processEvents(int numberOfEventsToProcess) {
        for (int eventsProcessed = 0; !this.pendingEvents.isEmpty() && eventsProcessed < numberOfEventsToProcess; ++eventsProcessed) {
            Node event = this.pendingEvents.remove(0);
            ContractUpdateAction update = this.singleEventContractProcessor.processEvent(event, this.currentInstance, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId);
            this.contractUpdateActions.add(update);
            this.currentInstance = update.getContractInstance();
            if (update.getEmittedEvents() != null) {
                this.pendingEvents.addAll(update.getEmittedEvents());
            }
            this.processedEvents.add(event);
        }
    }

    public List<Node> getProcessedEvents() {
        return new ArrayList<Node>(this.processedEvents);
    }

    public void processEmittedEventsOnly() {
        int initialPendingEventsCount = this.pendingEvents.size();
        for (int i = 0; i < initialPendingEventsCount; ++i) {
            if (this.pendingEvents.isEmpty()) continue;
            Node event = this.pendingEvents.remove(0);
            ContractUpdateAction update = this.singleEventContractProcessor.processEvent(event, this.currentInstance, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId);
            this.contractUpdateActions.add(update);
            this.currentInstance = update.getContractInstance();
            if (update.getEmittedEvents() == null) continue;
            this.pendingEvents.addAll(update.getEmittedEvents());
        }
    }

    public void save(String directory, String filePrefix) throws IOException {
        for (int i = 0; i < this.contractUpdateActions.size(); ++i) {
            ContractUpdateAction contractUpdateAction = this.contractUpdateActions.get(i);
            Node contractUpdateNode = (Node)UncheckedObjectMapper.JSON_MAPPER.convertValue((Object)contractUpdateAction, Node.class);
            File outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_update.blue");
            UncheckedObjectMapper.YAML_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractUpdateNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
            Node contractInstanceNode = contractUpdateNode.getAsNode("/contractInstance");
            outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_contractInstance.json");
            UncheckedObjectMapper.JSON_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractInstanceNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        }
    }

    public List<Node> getPendingEvents() {
        return new ArrayList<Node>(this.pendingEvents);
    }

    public int getCurrentFileId() {
        return this.contractUpdateActions.size();
    }

    public List<ContractUpdateAction> getContractUpdates() {
        return this.contractUpdateActions;
    }

    public ContractUpdateAction getLastContractUpdate() {
        return this.contractUpdateActions.isEmpty() ? null : this.contractUpdateActions.get(this.contractUpdateActions.size() - 1);
    }

    public void startProcessingContract(Contract contract, String runnerTimeline, Simulator simulator) {
        this.simulator = simulator;
        ContractUpdateAction initiateAction = this.initiateContract(contract);
        initiateAction.epoch(0);
        simulator.appendEntry(runnerTimeline, this.initiateContractProcessingEntryBlueId, initiateAction);
        simulator.subscribe(ContractRunnerSubscriptionUtils.createContractFilterForSimulator(contract, this.initiateContractEntryBlueId, runnerTimeline, simulator, this.blue), entry -> {
            int epoch = this.getLastContractUpdate().getEpoch();
            this.addEvent(entry);
            this.processEvents();
            ContractUpdateAction result = this.getLastContractUpdate();
            result.epoch(epoch + 1);
            simulator.appendEntry(runnerTimeline, this.initiateContractProcessingEntryBlueId, result);
        });
    }
}

