/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.ContractProcessor;
import blue.contract.model.Contract;
import blue.contract.model.ContractUpdateAction;
import blue.contract.processor.StandardProcessorsProvider;
import blue.contract.simulator.Simulator;
import blue.contract.simulator.utils.ContractRunnerSubscriptionUtils;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContractRunner2 {
    private final Blue blue;
    private final ContractProcessor contractProcessor;
    private final String initiateContractEntryBlueId;
    private final String initiateContractProcessingEntryBlueId;
    private List<ContractUpdateAction> contractUpdateActions = new ArrayList<ContractUpdateAction>();
    private Simulator simulator;

    public ContractRunner2(Blue blue, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        System.out.println("Initializing ContractRunner2");
        StandardProcessorsProvider provider = new StandardProcessorsProvider(blue);
        this.blue = blue;
        this.contractProcessor = new ContractProcessor(provider, blue);
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
        this.initiateContractProcessingEntryBlueId = initiateContractProcessingEntryBlueId;
        System.out.println("ContractRunner2 initialized with initiateContractEntryBlueId: " + initiateContractEntryBlueId + " and initiateContractProcessingEntryBlueId: " + initiateContractProcessingEntryBlueId);
    }

    public List<ContractUpdateAction> initiateContract(Object contract) {
        System.out.println("Initiating contract from Object");
        return this.initiateContract(this.blue.objectToNode(contract));
    }

    public List<ContractUpdateAction> initiateContract(Node contract) {
        System.out.println("Initiating contract from Node");
        List<ContractUpdateAction> actions = this.contractProcessor.initiate(contract, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId);
        System.out.println("Contract initiated. Number of update actions: " + actions.size());
        return actions;
    }

    public List<ContractUpdateAction> getContractUpdates() {
        System.out.println("Retrieving contract updates. Current count: " + this.contractUpdateActions.size());
        return this.contractUpdateActions;
    }

    public ContractUpdateAction getLastContractUpdate() {
        if (this.contractUpdateActions.isEmpty()) {
            System.out.println("No contract updates available");
            return null;
        }
        System.out.println("Retrieving last contract update");
        return this.contractUpdateActions.get(this.contractUpdateActions.size() - 1);
    }

    public void startProcessingContract(Contract contract, String runnerTimeline, Simulator simulator) {
        System.out.println("Setting up subscription for contract events");
        simulator.subscribe(ContractRunnerSubscriptionUtils.createContractFilterForSimulator(contract, this.initiateContractEntryBlueId, runnerTimeline, simulator, this.blue), entry -> {
            System.out.println("Processing new contract event");
            int epoch = this.getLastContractUpdate().getEpoch();
            System.out.println("Current epoch: " + epoch);
            ArrayList<Node> events = new ArrayList<Node>();
            if (this.initiateContractEntryBlueId.equals(entry.getThread())) {
                events.add(this.blue.objectToNode((Object)entry));
            } else {
                ContractUpdateAction action = (ContractUpdateAction)entry.getMessage();
                if (action.getEmittedEvents() != null) {
                    events.addAll(action.getEmittedEvents());
                }
            }
            for (Node event : events) {
                List<ContractUpdateAction> result = this.contractProcessor.processEvent(event, simulator.getMessageFromLastTimelineEntry(runnerTimeline, ContractUpdateAction.class).getContractInstance(), this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId, epoch + 1);
                System.out.println("Event processed. Number of new update actions: " + result.size());
                this.addContractUpdateActions(result);
                System.out.println("Appending new contract update actions to simulator");
                simulator.appendEntries(runnerTimeline, this.initiateContractProcessingEntryBlueId, result);
            }
        });
        System.out.println("Starting to process contract on runnerTimeline: " + runnerTimeline);
        List<ContractUpdateAction> actions = this.initiateContract(contract);
        this.addContractUpdateActions(actions);
        System.out.println("Appending initial contract update actions to simulator");
        simulator.appendEntries(runnerTimeline, this.initiateContractProcessingEntryBlueId, actions);
    }

    private void addContractUpdateActions(List<ContractUpdateAction> actions) {
        actions.forEach(action -> this.contractUpdateActions.add((ContractUpdateAction)this.blue.clone(action)));
    }

    public void save(String directory, String filePrefix) throws IOException {
        for (int i = 0; i < this.contractUpdateActions.size(); ++i) {
            ContractUpdateAction contractUpdateAction = this.contractUpdateActions.get(i);
            Node contractUpdateNode = (Node)UncheckedObjectMapper.JSON_MAPPER.convertValue((Object)contractUpdateAction, Node.class);
            File outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_update.blue");
            UncheckedObjectMapper.YAML_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractUpdateNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
            Node contractInstanceNode = contractUpdateNode.getAsNode("/contractInstance");
            outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_contractInstance.json");
            UncheckedObjectMapper.JSON_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractInstanceNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        }
    }
}

