/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.simulator.SimulatorMT;
import blue.language.Blue;
import java.util.concurrent.CountDownLatch;

public class Main {
    public static void main(String[] args) throws InterruptedException {
        Blue blue = new Blue();
        SimulatorMT simulator = new SimulatorMT(blue);
        String aliceTimeline = simulator.createTimeline("Alice");
        String bobTimeline = simulator.createTimeline("Bob");
        CountDownLatch latch = new CountDownLatch(4);
        simulator.subscribe(entry -> entry.getTimeline().equals(aliceTimeline), entry -> {
            System.out.println("Received message on Alice's timeline: " + entry.getMessage());
            latch.countDown();
        });
        simulator.subscribe(entry -> entry.getTimeline().equals(bobTimeline), entry -> {
            System.out.println("Received message on Bob's timeline: " + entry.getMessage());
            latch.countDown();
        });
        simulator.appendEntry(aliceTimeline, "Hello from Alice!");
        simulator.appendEntry(bobTimeline, "Hi there, I'm Bob!");
        simulator.appendEntry(aliceTimeline, "How are you doing, Bob?");
        simulator.appendEntry(bobTimeline, "I'm doing great, thanks for asking!");
        latch.await();
        simulator.shutdown();
    }
}

