/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator.processor;

import blue.contract.model.blink.LLMRequest;
import blue.contract.model.blink.LLMResponse;
import blue.contract.simulator.AssistantProcessor;
import blue.contract.utils.anthropic.Anthropic;
import blue.contract.utils.anthropic.AnthropicConfig;
import blue.contract.utils.anthropic.model.Content;
import blue.contract.utils.anthropic.model.Message;
import blue.contract.utils.anthropic.model.Request;
import blue.contract.utils.anthropic.model.Response;
import blue.language.Blue;
import blue.language.model.Node;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;

public class LLMRequestProcessor
implements AssistantProcessor<LLMRequest, LLMResponse> {
    private static final String DEFAULT_MODEL = "claude-3-5-sonnet-20240620";
    private static final int DEFAULT_MAX_TOKENS = 2048;
    private AnthropicConfig config;

    public LLMRequestProcessor(AnthropicConfig config) {
        this.config = config;
    }

    @Override
    public LLMResponse process(LLMRequest llmRequest, Blue blue) {
        try {
            long startTime = System.currentTimeMillis();
            Request anthropicRequest = new Request().model(DEFAULT_MODEL).max_tokens(2048);
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(new Message("user", this.buildPrompt(llmRequest, blue)));
            anthropicRequest.messages(messages);
            anthropicRequest.system("Process this task according to instructions.");
            anthropicRequest.temperature(0.0);
            Response anthropicResponse = new Anthropic(this.config).sendRequest(anthropicRequest);
            long endTime = System.currentTimeMillis();
            int responseTime = (int)(endTime - startTime);
            return this.buildLLMResponse(anthropicResponse, responseTime, blue);
        }
        catch (Exception e) {
            return new LLMResponse().content(new Node().value((Object)("Error when processing Anthropic request: " + e.getMessage())).type(new Node().blueId("F92yo19rCcbBoBSpUA5LRxpfDejJDAaP1PRxxbWAraVP"))).responseTime(-1);
        }
    }

    private String buildPrompt(LLMRequest llmRequest, Blue blue) {
        StringBuilder promptBuilder = new StringBuilder(llmRequest.getPrompt());
        if (llmRequest.getPromptParams() != null && !llmRequest.getPromptParams().isEmpty()) {
            promptBuilder.append("\n\nContext:");
            promptBuilder.append("\n").append(blue.objectToSimpleYaml(llmRequest.getPromptParams()));
        }
        return promptBuilder.toString();
    }

    private LLMResponse buildLLMResponse(Response anthropicResponse, int responseTime, Blue blue) {
        Content content;
        LLMResponse llmResponse = new LLMResponse().responseTime(responseTime);
        ObjectMapper objectMapper = new ObjectMapper();
        if (anthropicResponse.getContent() != null && !anthropicResponse.getContent().isEmpty() && (content = anthropicResponse.getContent().get(0)) != null && content.getText() != null) {
            String text = content.getText();
            try {
                objectMapper.readTree(text);
                llmResponse.content(blue.jsonToNode(content.getText()));
            }
            catch (Exception e) {
                llmResponse.content(new Node().value((Object)text).type(new Node().blueId("F92yo19rCcbBoBSpUA5LRxpfDejJDAaP1PRxxbWAraVP")));
            }
        }
        return llmResponse;
    }
}

