/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.graalvm.polyglot.io.FileSystem;

public class CustomFileSystem
implements FileSystem {
    private final FileSystem defaultFS;

    public CustomFileSystem(FileSystem defaultFS) {
        this.defaultFS = defaultFS;
    }

    public Path parsePath(URI uri) {
        if (uri.getScheme().equals("blue")) {
            return Paths.get("src", "main", "resources", "samples/chess.js");
        }
        return this.defaultFS.parsePath(uri);
    }

    public Path parsePath(String path) {
        if (path.startsWith("blue:")) {
            return Paths.get("src", "main", "resources", "samples/chess.js");
        }
        return this.defaultFS.parsePath(path);
    }

    public String readBlueResource(String resourceId) throws IOException {
        System.out.println("resourceId: " + resourceId);
        return new String(Files.readAllBytes(Paths.get("src", "main", "resources", "samples/chess.js")));
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.defaultFS.newByteChannel(path, options, (FileAttribute[])attrs);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.defaultFS.newDirectoryStream(dir, filter);
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.defaultFS.createDirectory(dir, (FileAttribute[])attrs);
    }

    public void delete(Path path) throws IOException {
        this.defaultFS.delete(path);
    }

    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.defaultFS.copy(source, target, options);
    }

    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.defaultFS.move(source, target, options);
    }

    public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
        return this.defaultFS.isSameFile(path1, path2, options);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        this.defaultFS.checkAccess(path, modes, linkOptions);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.defaultFS.readAttributes(path, attributes, options);
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.defaultFS.setAttribute(path, attribute, value, options);
    }

    public Path toAbsolutePath(Path path) {
        return this.defaultFS.toAbsolutePath(path);
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        return this.defaultFS.toRealPath(path, linkOptions);
    }

    public String getSeparator() {
        return this.defaultFS.getSeparator();
    }
}

