/*
 * Decompiled with CFR 0.152.
 */
package blue.strategic.parquet;

import blue.strategic.parquet.Hydrator;
import blue.strategic.parquet.HydratorSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetReader<U, S>
implements Spliterator<S>,
Closeable {
    private final ParquetFileReader reader;
    private final Hydrator<U, S> hydrator;
    private final List<ColumnDescriptor> columns;
    private final MessageType schema;
    private final GroupConverter recordConverter;
    private final String createdBy;
    private boolean finished;
    private long currentRowGroupSize = -1L;
    private List<ColumnReader> currentRowGroupColumnReaders;
    private long currentRowIndex = -1L;

    public static <U, S> Stream<S> streamContent(File file, HydratorSupplier<U, S> hydrator) throws IOException {
        return ParquetReader.streamContent(file, hydrator, null);
    }

    public static <U, S> Stream<S> streamContent(File file, HydratorSupplier<U, S> hydrator, Collection<String> columns) throws IOException {
        return ParquetReader.streamContent(ParquetReader.makeInputFile(file), hydrator, columns);
    }

    public static <U, S> Stream<S> streamContent(InputFile file, HydratorSupplier<U, S> hydrator) throws IOException {
        return ParquetReader.streamContent(file, hydrator, null);
    }

    public static <U, S> Stream<S> streamContent(InputFile file, HydratorSupplier<U, S> hydrator, Collection<String> columns) throws IOException {
        return ParquetReader.stream(ParquetReader.spliterator(file, hydrator, columns));
    }

    public static <U, S> ParquetReader<U, S> spliterator(File file, HydratorSupplier<U, S> hydrator) throws IOException {
        return ParquetReader.spliterator(file, hydrator, null);
    }

    public static <U, S> ParquetReader<U, S> spliterator(File file, HydratorSupplier<U, S> hydrator, Collection<String> columns) throws IOException {
        return ParquetReader.spliterator(ParquetReader.makeInputFile(file), hydrator, columns);
    }

    public static <U, S> ParquetReader<U, S> spliterator(InputFile file, HydratorSupplier<U, S> hydrator) throws IOException {
        return ParquetReader.spliterator(file, hydrator, null);
    }

    public static <U, S> ParquetReader<U, S> spliterator(InputFile file, HydratorSupplier<U, S> hydrator, Collection<String> columns) throws IOException {
        Set<String> columnSet = null == columns ? Collections.emptySet() : Set.copyOf(columns);
        return new ParquetReader<U, S>(file, columnSet, hydrator);
    }

    public static <U, S> Stream<S> stream(ParquetReader<U, S> reader) {
        return (Stream)StreamSupport.stream(reader, false).onClose(() -> ParquetReader.closeSilently(reader));
    }

    public static Stream<String[]> streamContentToStrings(File file) throws IOException {
        return ParquetReader.stream(ParquetReader.spliterator(ParquetReader.makeInputFile(file), (List<ColumnDescriptor> columns) -> {
            final AtomicInteger pos = new AtomicInteger(0);
            return new Hydrator<String[], String[]>(){

                @Override
                public String[] start() {
                    return new String[columns.size()];
                }

                @Override
                public String[] add(String[] target, String heading, Object value) {
                    target[pos.getAndIncrement()] = heading + "=" + value.toString();
                    return target;
                }

                @Override
                public String[] finish(String[] target) {
                    return target;
                }
            };
        }, null));
    }

    public static ParquetMetadata readMetadata(File file) throws IOException {
        return ParquetReader.readMetadata(ParquetReader.makeInputFile(file));
    }

    public static ParquetMetadata readMetadata(InputFile file) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            ParquetMetadata parquetMetadata = reader.getFooter();
            return parquetMetadata;
        }
    }

    private ParquetReader(InputFile file, Set<String> columnNames, HydratorSupplier<U, S> hydratorSupplier) throws IOException {
        this.reader = ParquetFileReader.open((InputFile)file);
        FileMetaData meta = this.reader.getFooter().getFileMetaData();
        this.schema = meta.getSchema();
        this.recordConverter = new DummyRecordConverter(this.schema).getRootConverter();
        this.createdBy = meta.getCreatedBy();
        this.columns = this.schema.getColumns().stream().filter(c -> columnNames.isEmpty() || columnNames.contains(c.getPath()[0])).collect(Collectors.toList());
        this.hydrator = hydratorSupplier.get(this.columns);
    }

    private static void closeSilently(Closeable resource) {
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object readValue(ColumnReader columnReader) {
        ColumnDescriptor column = columnReader.getDescriptor();
        PrimitiveType primitiveType = column.getPrimitiveType();
        int maxDefinitionLevel = column.getMaxDefinitionLevel();
        if (columnReader.getCurrentDefinitionLevel() == maxDefinitionLevel) {
            switch (primitiveType.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: 
                case INT96: {
                    return primitiveType.stringifier().stringify(columnReader.getBinary());
                }
                case BOOLEAN: {
                    return columnReader.getBoolean();
                }
                case DOUBLE: {
                    return columnReader.getDouble();
                }
                case FLOAT: {
                    return Float.valueOf(columnReader.getFloat());
                }
                case INT32: {
                    return columnReader.getInteger();
                }
                case INT64: {
                    return columnReader.getLong();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitiveType);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean tryAdvance(Consumer<? super S> action) {
        try {
            if (this.finished) {
                return false;
            }
            if (this.currentRowIndex == this.currentRowGroupSize) {
                PageReadStore rowGroup = this.reader.readNextRowGroup();
                if (rowGroup == null) {
                    this.finished = true;
                    return false;
                }
                ColumnReadStoreImpl columnReadStore = new ColumnReadStoreImpl(rowGroup, this.recordConverter, this.schema, this.createdBy);
                this.currentRowGroupSize = rowGroup.getRowCount();
                this.currentRowGroupColumnReaders = this.columns.stream().map(arg_0 -> ((ColumnReadStore)columnReadStore).getColumnReader(arg_0)).collect(Collectors.toList());
                this.currentRowIndex = 0L;
            }
            U record = this.hydrator.start();
            for (ColumnReader columnReader : this.currentRowGroupColumnReaders) {
                record = this.hydrator.add(record, columnReader.getDescriptor().getPath()[0], ParquetReader.readValue(columnReader));
                columnReader.consume();
                if (columnReader.getCurrentRepetitionLevel() == 0) continue;
                throw new IllegalStateException("Unexpected repetition");
            }
            action.accept(this.hydrator.finish(record));
            ++this.currentRowIndex;
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read parquet", e);
        }
    }

    @Override
    public Spliterator<S> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.reader.getRecordCount();
    }

    @Override
    public int characteristics() {
        return 273;
    }

    public ParquetMetadata metaData() {
        return this.reader.getFooter();
    }

    public static InputFile makeInputFile(final File file) {
        return new InputFile(){

            public long getLength() {
                return file.length();
            }

            public SeekableInputStream newStream() throws IOException {
                final FileInputStream fis = new FileInputStream(file);
                return new DelegatingSeekableInputStream(fis){
                    private long position;

                    public long getPos() {
                        return this.position;
                    }

                    public void seek(long newPos) throws IOException {
                        fis.getChannel().position(newPos);
                        this.position = newPos;
                    }
                };
            }
        };
    }
}

